/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.contentparser.api;

import java.lang.reflect.Array;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public final class ParserHelper {
    private static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    private static final String ISO_8601_MILLISECONDS_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSVV";
    private static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private static final DateTimeFormatter ECMA_DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", DATE_FORMAT_LOCALE);
    private static final DateTimeFormatter ISO_8601_MILLISECONDS_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSVV", DATE_FORMAT_LOCALE);

    private ParserHelper() {
    }

    public static Calendar parseDate(String string) {
        try {
            return ParserHelper.parseDate(string, ISO_8601_MILLISECONDS_DATE_FORMATTER);
        }
        catch (DateTimeParseException e) {
            try {
                return ParserHelper.parseDate(string, ECMA_DATE_FORMATTER);
            }
            catch (DateTimeParseException ee) {
                return null;
            }
        }
    }

    public static Object convertSingleTypeArray(Object[] values) {
        if (values.length == 0) {
            return values;
        }
        Class<?> itemType = null;
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Multi-value array must not contain null values.");
            }
            if (value instanceof Map) {
                throw new IllegalArgumentException("Multi-value array must not contain maps/objects.");
            }
            if (itemType == null) {
                itemType = value.getClass();
                continue;
            }
            if (itemType == value.getClass()) continue;
            throw new IllegalArgumentException("Multi-value array must not contain values with different types (" + itemType.getName() + ", " + value.getClass().getName() + ").");
        }
        Object convertedArray = Array.newInstance(itemType, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(convertedArray, i, values[i]);
        }
        return convertedArray;
    }

    private static Calendar parseDate(String string, DateTimeFormatter formatter) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(string, formatter);
        Instant instant = zonedDateTime.toInstant();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date.from(instant));
        calendar.setTimeZone(TimeZone.getTimeZone(zonedDateTime.getOffset()));
        return calendar;
    }
}

