/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.contentparser.testutils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserOptions;
import org.apache.sling.contentparser.testutils.mapsupport.ContentElement;
import org.apache.sling.contentparser.testutils.mapsupport.ContentElementHandler;

public final class TestUtils {
    private TestUtils() {
    }

    public static ContentElement parse(ContentParser contentParser, File file) throws IOException {
        return TestUtils.parse(contentParser, new ParserOptions(), file);
    }

    public static ContentElement parse(ContentParser contentParser, ParserOptions parserOptions, File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            ContentElement contentElement;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                ContentElementHandler handler = new ContentElementHandler();
                contentParser.parse((ContentHandler)handler, (InputStream)bis, parserOptions);
                contentElement = handler.getRoot();
            }
            return contentElement;
        }
    }

    public static ContentElement parse(ContentParser contentParser, String jsonContent) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));){
            ContentElementHandler handler = new ContentElementHandler();
            contentParser.parse((ContentHandler)handler, (InputStream)is, new ParserOptions());
            ContentElement contentElement = handler.getRoot();
            return contentElement;
        }
    }
}

