/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.extensions.sling;

import java.util.LinkedList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.apache.sling.crankstart.api.CrankstartException;
import org.apache.sling.crankstart.extensions.sling.InstallerRegisterCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class InstallerResourceCommand
implements CrankstartCommand {
    public static final String I_INSTALLER_RESOURCE = "sling.installer.resource";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_INSTALLER_RESOURCE.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "sling.installer.resource: prepares a resource for registration with the Sling installer";
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        String resourceRef = commandLine.getQualifier();
        if (resourceRef == null || resourceRef.length() == 0) {
            throw new CrankstartException("Missing command qualifier, required to specifiy the resource to register");
        }
        LinkedList<String> resources = (LinkedList<String>)crankstartContext.getAttribute(InstallerRegisterCommand.CONTEXT_ATTRIBUTE_NAME);
        if (resources == null) {
            resources = new LinkedList<String>();
            crankstartContext.setAttribute(InstallerRegisterCommand.CONTEXT_ATTRIBUTE_NAME, resources);
        }
        resources.add(resourceRef);
        this.log.info("Installer resource prepared: {}", (Object)resourceRef);
    }
}

