/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.datasource.internal;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.sling.datasource.internal.DataSourceFactory;
import org.apache.sling.datasource.internal.DriverRegistry;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolUtilities;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DriverDataSource
implements DataSource {
    private final PoolConfiguration poolProperties;
    private final DriverRegistry driverRegistry;
    private final BundleContext bundleContext;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Driver driver;
    private final DataSourceFactory dataSourceFactory;

    public DriverDataSource(PoolConfiguration poolProperties, DriverRegistry driverRegistry, BundleContext bundleContext, DataSourceFactory dataSourceFactory) {
        this.poolProperties = poolProperties;
        this.driverRegistry = driverRegistry;
        this.bundleContext = bundleContext;
        this.dataSourceFactory = dataSourceFactory;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String usr, String pwd) throws SQLException {
        Connection connection;
        Properties properties = PoolUtilities.clone(this.poolProperties.getDbProperties());
        if (usr == null) {
            usr = this.poolProperties.getUsername();
        }
        if (pwd == null) {
            pwd = this.poolProperties.getPassword();
        }
        if (usr != null) {
            properties.setProperty("user", usr);
        }
        if (pwd != null) {
            properties.setProperty("password", pwd);
        }
        String driverURL = this.poolProperties.getUrl();
        try {
            connection = this.getDriver().connect(driverURL, properties);
        }
        catch (Exception x) {
            org.apache.tomcat.jdbc.pool.jmx.ConnectionPool jmxPool;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to connect to database.", (Throwable)x);
            }
            if ((jmxPool = this.getJmxPool()) != null) {
                jmxPool.notify("CONNECTION FAILED", ConnectionPool.getStackTrace(x));
            }
            if (x instanceof SQLException) {
                throw (SQLException)x;
            }
            SQLException ex = new SQLException(x.getMessage());
            ex.initCause(x);
            throw ex;
        }
        if (connection == null) {
            throw new SQLException("Driver:" + this.driver + " returned null for URL:" + driverURL);
        }
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private org.apache.tomcat.jdbc.pool.jmx.ConnectionPool getJmxPool() {
        if (this.dataSourceFactory.getPool() != null) {
            return this.dataSourceFactory.getPool().getJmxPool();
        }
        return null;
    }

    private Driver getDriver() throws SQLException {
        if (this.driver != null) {
            return this.driver;
        }
        String url = this.poolProperties.getUrl();
        Collection<Driver> drivers = this.driverRegistry.getDrivers();
        if (!drivers.isEmpty()) {
            this.log.debug("Looking for driver for [{}] against registered drivers", (Object)url);
            this.driver = this.findMatchingDriver(drivers);
        }
        if (this.driver == null && this.poolProperties.getDriverClassName() != null) {
            this.log.debug("Looking for driver for [{}] via provided className [{}]", (Object)url, (Object)this.poolProperties.getDriverClassName());
            this.driver = this.loadDriverClass();
        }
        if (this.driver == null) {
            this.log.debug("Looking for driver from DriverManager");
            this.driver = this.findMatchingDriver(Collections.list(DriverManager.getDrivers()));
        }
        if (this.driver == null) {
            String msg = String.format("Not able to find any matching driver for url [%s] and driverClassName [%s]", url, this.poolProperties.getDriverClassName());
            throw new SQLException(msg);
        }
        return this.driver;
    }

    private Driver loadDriverClass() throws SQLException {
        try {
            this.log.debug("Instantiating driver using class: {} [url={}]", (Object)this.poolProperties.getDriverClassName(), (Object)this.poolProperties.getUrl());
            return (Driver)this.bundleContext.getBundle().loadClass(this.poolProperties.getDriverClassName()).newInstance();
        }
        catch (Exception cn) {
            this.log.debug("Unable to instantiate JDBC driver.", (Throwable)cn);
            SQLException ex = new SQLException(cn.getMessage());
            ex.initCause(cn);
            throw ex;
        }
    }

    private Driver findMatchingDriver(Collection<Driver> drivers) {
        String url = this.poolProperties.getUrl();
        for (Driver driver : drivers) {
            try {
                if (!driver.acceptsURL(url)) continue;
                return driver;
            }
            catch (SQLException e) {
                this.log.debug("Error occurred while matching driver against url {}", (Object)url, (Object)e);
            }
        }
        return null;
    }
}

