/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.PersistedJcrEventDistributionTrigger;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionTrigger.class}, property={"webconsole.configurationFactory.nameHint=Trigger name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class PersistedJcrEventDistributionTriggerFactory
implements DistributionTrigger {
    private PersistedJcrEventDistributionTrigger trigger;
    @Reference
    private SlingRepository repository;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Activate
    public void activate(BundleContext bundleContext, Config conf) {
        String path = conf.path();
        String serviceName = SettingsUtils.removeEmptyEntry(conf.serviceName());
        String nuggetsPath = conf.nuggetsPath();
        this.trigger = new PersistedJcrEventDistributionTrigger(this.repository, this.scheduler, this.resolverFactory, path, serviceName, nuggetsPath);
        this.trigger.enable();
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Trigger - Persisted Jcr Event Triggers Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the trigger.")
        public String name();

        @AttributeDefinition(name="Name", description="The path for which changes are listened and distributed as persisted nugget events.")
        public String path();

        @AttributeDefinition(name="Service Name", description="The service used to listen for jcr events")
        public String serviceName();

        @AttributeDefinition(name="Nuggets Path", description="The location where serialization of jcr events will be stored")
        public String nuggetsPath() default "/var/sling/distribution/nuggets";
    }
}

