/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.publisher;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.BinaryStore;
import org.apache.sling.distribution.journal.impl.publisher.PackageFactoryConfiguration;
import org.apache.sling.distribution.journal.messages.PackageMessage;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(service={PackageMessageFactory.class})
@Designate(ocd=PackageFactoryConfiguration.class)
public class PackageMessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PackageMessageFactory.class);
    @Reference
    private SlingSettingsService slingSettings;
    @Reference
    private BinaryStore binaryStore;
    private String pubSlingId;
    private long maxPackageSize = -1L;

    @Activate
    public void activate(PackageFactoryConfiguration packageFactoryConfiguration) {
        this.maxPackageSize = packageFactoryConfiguration.maxPackageSize();
        this.pubSlingId = this.slingSettings.getSlingId();
        LOG.info("Started package message factory for pubSlingId={}, maxPackageSize={}", (Object)this.pubSlingId, (Object)this.maxPackageSize);
    }

    @Deactivate
    public void deactivate() {
        LOG.info("Stopped package message factory for pubSlingId={}", (Object)this.pubSlingId);
    }

    public PackageMessage create(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, String pubAgentName, DistributionRequest request) throws DistributionException {
        switch (request.getRequestType()) {
            case ADD: {
                return this.createAdd(packageBuilder, resourceResolver, pubAgentName, request);
            }
            case DELETE: {
                return this.createDelete(packageBuilder, resourceResolver, request, pubAgentName);
            }
            case INVALIDATE: {
                return this.createInvalidate(packageBuilder, resourceResolver, request, pubAgentName);
            }
            case TEST: {
                return this.createTest(packageBuilder, resourceResolver, request, pubAgentName);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported request with requestType=%s", request.getRequestType()));
    }

    @Nonnull
    private PackageMessage createAdd(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, String pubAgentName, DistributionRequest request) throws DistributionException {
        String storeRef;
        DistributionPackage disPkg = Objects.requireNonNull(packageBuilder.createPackage(resourceResolver, request));
        byte[] pkgBinary = this.pkgBinary(disPkg);
        long pkgLength = this.assertPkgLength(pkgBinary.length);
        DistributionPackageInfo pkgInfo = disPkg.getInfo();
        List<String> paths = Arrays.asList(pkgInfo.getPaths());
        List<String> deepPaths = Arrays.asList((String[])pkgInfo.get("request.deepPaths", String[].class));
        String pkgId = disPkg.getId();
        PackageMessage.PackageMessageBuilder pkgBuilder = PackageMessage.builder().pubSlingId(this.pubSlingId).pkgId(pkgId).pubAgentName(pubAgentName).paths(paths).reqType(PackageMessage.ReqType.ADD).deepPaths(deepPaths).pkgLength(pkgLength).userId(resourceResolver.getUserID()).pkgType(packageBuilder.getType());
        try {
            storeRef = this.binaryStore.put(pkgId, disPkg.createInputStream(), pkgLength);
        }
        catch (IOException e) {
            throw new DistributionException(e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)storeRef)) {
            pkgBuilder.pkgBinaryRef(storeRef);
        } else {
            pkgBuilder.pkgBinary(pkgBinary);
        }
        PackageMessage pipePackage = pkgBuilder.build();
        disPkg.delete();
        return pipePackage;
    }

    @Nonnull
    private PackageMessage createInvalidate(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, DistributionRequest request, String pubAgentName) {
        String pkgId = UUID.randomUUID().toString();
        return PackageMessage.builder().pubSlingId(this.pubSlingId).pkgId(pkgId).pubAgentName(pubAgentName).paths(Arrays.asList(request.getPaths())).reqType(PackageMessage.ReqType.INVALIDATE).pkgType(packageBuilder.getType()).userId(resourceResolver.getUserID()).build();
    }

    @Nonnull
    private PackageMessage createDelete(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, DistributionRequest request, String pubAgentName) {
        String pkgId = UUID.randomUUID().toString();
        return PackageMessage.builder().pubSlingId(this.pubSlingId).pkgId(pkgId).pubAgentName(pubAgentName).paths(Arrays.asList(request.getPaths())).reqType(PackageMessage.ReqType.DELETE).pkgType(packageBuilder.getType()).userId(resourceResolver.getUserID()).build();
    }

    @Nonnull
    public PackageMessage createTest(DistributionPackageBuilder packageBuilder, ResourceResolver resourceResolver, DistributionRequest request, String pubAgentName) {
        String pkgId = UUID.randomUUID().toString();
        return PackageMessage.builder().pubSlingId(this.pubSlingId).pkgId(pkgId).pubAgentName(pubAgentName).paths(Arrays.asList(request.getPaths())).reqType(PackageMessage.ReqType.TEST).pkgType(packageBuilder.getType()).userId(resourceResolver.getUserID()).build();
    }

    @Nonnull
    private byte[] pkgBinary(DistributionPackage pkg) {
        try {
            return IOUtils.toByteArray((InputStream)pkg.createInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long assertPkgLength(long pkgLength) throws DistributionException {
        if (this.maxPackageSize >= 0L && pkgLength > this.maxPackageSize) {
            throw new DistributionException(String.format("Can't distribute package with size greater than %s Byte, actual %s", this.maxPackageSize, pkgLength));
        }
        return pkgLength;
    }
}

