/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.apiregions.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.sling.feature.apiregions.impl.Activator;
import org.apache.sling.feature.apiregions.impl.RegionConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

class ResolverHookImpl
implements ResolverHook {
    final RegionConfiguration configuration;

    ResolverHookImpl(RegionConfiguration cfg) {
        this.configuration = cfg;
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        if (!"osgi.wiring.package".equals(requirement.getNamespace())) {
            return;
        }
        if (candidates.isEmpty()) {
            return;
        }
        Object pkg = candidates.iterator().next().getAttributes().get("osgi.wiring.package");
        if (!(pkg instanceof String)) {
            return;
        }
        String packageName = (String)pkg;
        Bundle reqBundle = requirement.getRevision().getBundle();
        long reqBundleID = reqBundle.getBundleId();
        HashSet<String> bareReqRegions = null;
        Set<String> reqFeatures = this.getFeaturesForBundle(reqBundle);
        for (String feature : reqFeatures) {
            List<String> fr = this.configuration.getFeatureRegionMap().get(feature);
            if (fr == null) continue;
            if (bareReqRegions == null) {
                bareReqRegions = new HashSet<String>();
            }
            bareReqRegions.addAll(fr);
        }
        HashSet<String> reqRegions = new HashSet<String>(this.configuration.getDefaultRegions());
        if (bareReqRegions != null) {
            reqRegions.addAll(bareReqRegions);
        }
        HashMap<BundleCapability, String> coveredCaps = new HashMap<BundleCapability, String>();
        HashMap<BundleCapability, String> bcFeatureMap = new HashMap<BundleCapability, String>();
        block1: for (BundleCapability bc : candidates) {
            Set<String> capFeatures;
            BundleRevision rev = bc.getRevision();
            Bundle capBundle = rev.getBundle();
            long capBundleID = capBundle.getBundleId();
            if (capBundleID == 0L) {
                coveredCaps.put(bc, null);
                continue;
            }
            if (capBundleID == reqBundleID) {
                coveredCaps.put(bc, "global");
            }
            if ((capFeatures = this.getFeaturesForBundle(capBundle)).isEmpty()) {
                coveredCaps.put(bc, "global");
                continue;
            }
            for (String capFeat : capFeatures) {
                if (reqFeatures.contains(capFeat)) {
                    coveredCaps.put(bc, this.isInGlobalRegion(packageName, capFeat) ? "global" : null);
                    continue block1;
                }
                List<String> capRegions = this.configuration.getFeatureRegionMap().get(capFeat);
                if (capRegions == null || capRegions.size() == 0) {
                    coveredCaps.put(bc, "global");
                    continue block1;
                }
                bcFeatureMap.put(bc, capFeat);
                ArrayList<String> sharedRegions = new ArrayList<String>(this.getRegionsAndAncestors(reqRegions));
                sharedRegions.retainAll(capRegions);
                for (String region : sharedRegions) {
                    Set<String> regionPackages = this.configuration.getRegionPackageMap().get(region);
                    if (regionPackages == null || !regionPackages.contains(packageName)) continue;
                    coveredCaps.put(bc, region);
                    continue block1;
                }
                Set<String> globalPackages = this.configuration.getRegionPackageMap().get("global");
                if (globalPackages == null || !globalPackages.contains(packageName)) continue;
                coveredCaps.put(bc, "global");
                continue block1;
            }
        }
        this.pruneCoveredCaps(bareReqRegions, coveredCaps);
        ArrayList<BundleCapability> removedCandidates = new ArrayList<BundleCapability>(candidates);
        candidates.retainAll(coveredCaps.keySet());
        Level logLevel = candidates.isEmpty() ? Level.WARNING : Level.INFO;
        removedCandidates.removeAll(candidates);
        if (!removedCandidates.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (BundleCapability bc : removedCandidates) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                String capFeat = (String)bcFeatureMap.get(bc);
                sb.append(bc.toString());
                sb.append("[Regions: ");
                sb.append(this.getRegionsForPackage(packageName, capFeat));
                sb.append(", Feature: ");
                sb.append(capFeat);
                sb.append("]");
            }
            Activator.LOG.log(logLevel, "API-Regions removed candidates {0} for requirement {1} as the requirement is in the following regions: {2} and in feature: {3}", new Object[]{sb, requirement, reqRegions, reqFeatures});
        }
    }

    private Set<String> getRegionsAndAncestors(Set<String> regions) {
        HashSet<String> s = new HashSet<String>();
        for (String region : regions) {
            s.add(region);
            if (this.configuration.getGlobalRegionOrder().contains(region)) {
                for (String r : this.configuration.getGlobalRegionOrder()) {
                    if (r.equals(region)) break;
                    s.add(r);
                }
                continue;
            }
            Activator.LOG.log(Level.WARNING, "Global API Region order " + this.configuration.getGlobalRegionOrder() + " does not contain region: " + region);
        }
        return s;
    }

    private boolean isInGlobalRegion(String packageName, String capFeat) {
        Set<String> globalPackages;
        List<String> capRegions = this.configuration.getFeatureRegionMap().get(capFeat);
        return capRegions != null && capRegions.contains("global") && (globalPackages = this.configuration.getRegionPackageMap().get("global")).contains(packageName);
    }

    private void pruneCoveredCaps(Set<String> reqRegions, Map<BundleCapability, String> capMap) {
        if (reqRegions == null) {
            return;
        }
        HashSet<String> reqNonGlobalRegions = new HashSet<String>(reqRegions);
        reqNonGlobalRegions.remove("global");
        if (capMap.size() <= 1) {
            return;
        }
        ArrayList<BundleCapability> specificCaps = new ArrayList<BundleCapability>();
        for (Map.Entry<BundleCapability, String> entry : capMap.entrySet()) {
            String capRegion = entry.getValue();
            if (capRegion == null) {
                specificCaps.add(entry.getKey());
                continue;
            }
            if (!reqNonGlobalRegions.contains(capRegion)) continue;
            specificCaps.add(entry.getKey());
        }
        if (specificCaps.size() == 0) {
            return;
        }
        Iterator<Map.Entry<BundleCapability, String>> it = capMap.keySet().iterator();
        while (it.hasNext()) {
            BundleCapability cap = (BundleCapability)it.next();
            if (specificCaps.contains(cap)) continue;
            it.remove();
            Activator.LOG.log(Level.INFO, "Removing candidate {0} which is in region {1} as more specific candidate(s) are available in regions {2}", new Object[]{cap, capMap.get(cap), specificCaps.stream().map(c -> "" + c + " region " + (String)capMap.get(c)).collect(Collectors.joining("/"))});
        }
    }

    Set<String> getFeaturesForBundle(Bundle bundle) {
        Map.Entry bsnVer = this.configuration.getBundleLocationConfigMap().computeIfAbsent(bundle.getLocation(), l -> new AbstractMap.SimpleEntry<String, Version>(bundle.getSymbolicName(), bundle.getVersion()));
        return this.getFeaturesForBundleFromConfig((String)bsnVer.getKey(), (Version)bsnVer.getValue());
    }

    private Set<String> getFeaturesForBundleFromConfig(String bundleName, Version bundleVersion) {
        HashSet<String> newSet = new HashSet<String>();
        List<String> aids = this.configuration.getBsnVerMap().get(new AbstractMap.SimpleEntry<String, Version>(bundleName, bundleVersion));
        if (aids != null) {
            for (String aid : aids) {
                Set<String> fid = this.configuration.getBundleFeatureMap().get(aid);
                if (fid == null) continue;
                newSet.addAll(fid);
            }
        }
        return Collections.unmodifiableSet(newSet);
    }

    List<String> getRegionsForPackage(String packageName, String feature) {
        if (packageName == null) {
            return Collections.emptyList();
        }
        List<String> regions = this.configuration.getFeatureRegionMap().get(feature);
        if (regions == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String region : regions) {
            Set<String> packages = this.configuration.getRegionPackageMap().get(region);
            if (packages == null || !packages.contains(packageName)) continue;
            res.add(region);
        }
        return res;
    }

    public void end() {
    }
}

