/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;

public class Artifact
implements Comparable<Artifact> {
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_START_ORDER = "start-order";
    public static final String KEY_FEATURE_ORIGINS = "feature-origins";
    private final ArtifactId id;
    private final Map<String, String> metadata = new HashMap<String, String>();

    public Artifact(ArtifactId id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        this.id = id;
    }

    public ArtifactId getId() {
        return this.id;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Set<ArtifactId> getAliases(boolean includeMain) {
        String aliases;
        HashSet<ArtifactId> artifactIds = new HashSet<ArtifactId>();
        if (includeMain) {
            artifactIds.add(this.getId());
        }
        if ((aliases = this.getMetadata().get(KEY_ALIAS)) != null) {
            for (String alias : aliases.split(",")) {
                if ((alias = alias.trim()).indexOf(58) == alias.lastIndexOf(58)) {
                    alias = alias + ":0.0.0";
                }
                artifactIds.add(ArtifactId.fromMvnId(alias));
            }
        }
        return artifactIds;
    }

    public int getStartOrder() {
        int startOrder;
        String order = this.getMetadata().get(KEY_START_ORDER);
        if (order != null) {
            startOrder = Integer.parseInt(order);
            if (startOrder < 0) {
                throw new IllegalStateException("Start order must be >= 0 but is " + order);
            }
        } else {
            startOrder = 0;
        }
        return startOrder;
    }

    public void setStartOrder(int startOrder) {
        if (startOrder < 0) {
            throw new IllegalArgumentException("Start order must be >= 0 but is " + startOrder);
        }
        if (startOrder == 0) {
            this.getMetadata().remove(KEY_START_ORDER);
        } else {
            this.getMetadata().put(KEY_START_ORDER, String.valueOf(startOrder));
        }
    }

    public ArtifactId[] getFeatureOrigins() {
        Set<ArtifactId> originFeatures;
        String origins = this.getMetadata().get(KEY_FEATURE_ORIGINS);
        if (origins == null || origins.trim().isEmpty()) {
            originFeatures = Collections.emptySet();
        } else {
            originFeatures = new LinkedHashSet();
            for (String origin : origins.split(",")) {
                if (origin.trim().isEmpty()) continue;
                originFeatures.add(ArtifactId.parse(origin));
            }
        }
        return originFeatures.toArray(new ArtifactId[0]);
    }

    public void setFeatureOrigins(ArtifactId ... featureOrigins) {
        String origins = featureOrigins != null && featureOrigins.length > 0 ? Stream.of(featureOrigins).filter(Objects::nonNull).map(ArtifactId::toMvnId).distinct().collect(Collectors.joining(",")) : "";
        if (!origins.trim().isEmpty()) {
            this.getMetadata().put(KEY_FEATURE_ORIGINS, origins);
        } else {
            this.getMetadata().remove(KEY_FEATURE_ORIGINS);
        }
    }

    @Override
    public int compareTo(Artifact o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((Artifact)obj).id);
    }

    public Artifact copy(ArtifactId id) {
        Artifact result = new Artifact(id);
        result.getMetadata().putAll(this.getMetadata());
        return result;
    }

    public String toString() {
        return "Artifact [id=" + this.id.toMvnId() + "]";
    }
}

