/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.impl;

import java.io.IOException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EventHandler.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class FileOptimizerEventHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(FileOptimizerEventHandler.class);
    @Reference
    private FileOptimizerService fileOptimizer;
    private ResourceResolver resourceResolver;
    @Reference
    private ResourceResolverFactory rrf;

    @Activate
    @Modified
    public void activate(Config config) throws LoginException {
        this.deactivate();
        this.resourceResolver = this.rrf.getServiceResourceResolver(null);
    }

    @Deactivate
    public void deactivate() {
        if (this.resourceResolver != null) {
            this.resourceResolver.close();
        }
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        Resource fileResource = this.resourceResolver.getResource(path);
        if (fileResource != null && this.fileOptimizer.canOptimize(fileResource)) {
            try {
                this.fileOptimizer.optimizeFile(fileResource, true);
            }
            catch (IOException e) {
                log.error("Exception saving optimized file", (Throwable)e);
            }
        }
    }

    @ObjectClassDefinition(name="%event.handler.name", description="%event.handler.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%event.handler.filter.name", description="%event.handler.filter.description")
        public String event_filter() default "(&(resourceType=sling:File)(|(path=*.png)(path=*.jpg)))";

        @AttributeDefinition(name="%event.handler.topics.name", description="%event.handler.topics.description")
        public String[] event_topics() default {"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED"};
    }
}

