/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.sling.graphql.api.SlingGraphQLException;
import org.apache.sling.graphql.api.pagination.Connection;
import org.apache.sling.graphql.api.pagination.Cursor;
import org.apache.sling.graphql.api.pagination.Edge;
import org.apache.sling.graphql.api.pagination.PageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public final class GenericConnection<T>
implements Connection<T>,
PageInfo {
    public static final int DEFAULT_LIMIT = 10;
    public static final int MAX_LIMIT = 100;
    private final List<Edge<T>> edges;
    private final Iterator<T> dataIterator;
    private final Function<T, String> cursorStringProvider;
    private boolean initialized;
    private Cursor startAfter = null;
    private Cursor startCursor = null;
    private Cursor endCursor = null;
    private Boolean hasPreviousPage;
    private Boolean hasNextPage;
    private int limit = 10;

    private GenericConnection(@NotNull Iterator<T> dataIterator, @NotNull Function<T, String> cursorStringProvider) {
        GenericConnection.checkNotNull(dataIterator, "Data iterator");
        GenericConnection.checkNotNull(cursorStringProvider, "Cursor string provider function");
        this.edges = new ArrayList<Edge<T>>();
        this.dataIterator = dataIterator;
        this.cursorStringProvider = cursorStringProvider;
    }

    private void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        boolean inRange = false;
        int itemsToAdd = this.limit;
        while (itemsToAdd > 0 && this.dataIterator.hasNext()) {
            T node = this.dataIterator.next();
            boolean addThisNode = false;
            if (!inRange) {
                if (this.startAfter == null) {
                    inRange = true;
                    addThisNode = true;
                    if (this.hasPreviousPage == null) {
                        this.hasPreviousPage = false;
                    }
                } else {
                    String rawCursor = this.cursorStringProvider.apply(node);
                    inRange = this.startAfter.getRawValue().equals(rawCursor);
                    if (this.hasPreviousPage == null) {
                        this.hasPreviousPage = true;
                    }
                }
            } else {
                addThisNode = true;
            }
            if (!addThisNode) continue;
            Edge<T> toAdd = this.newEdge(node, this.cursorStringProvider);
            if (this.startCursor == null) {
                this.startCursor = toAdd.getCursor();
            }
            this.endCursor = toAdd.getCursor();
            this.edges.add(toAdd);
            --itemsToAdd;
        }
        if (!inRange && this.limit > 0 && this.startAfter != null) {
            throw new SlingGraphQLException("Start cursor not found in supplied data:" + this.startAfter);
        }
        if (this.hasPreviousPage == null) {
            this.hasPreviousPage = false;
        }
        if (this.hasNextPage == null) {
            this.hasNextPage = this.dataIterator.hasNext();
        }
    }

    private static void checkNotNull(Object o, String whatIsThat) {
        if (o == null) {
            throw new IllegalArgumentException(whatIsThat + " is null");
        }
    }

    private Edge<T> newEdge(final T node, final Function<T, String> cursorStringProvider) {
        return new Edge<T>(){

            @Override
            @NotNull
            public T getNode() {
                return node;
            }

            @Override
            @NotNull
            public Cursor getCursor() {
                return new Cursor((String)cursorStringProvider.apply(node));
            }
        };
    }

    @Override
    @NotNull
    public Iterable<Edge<T>> getEdges() {
        return this.edges;
    }

    @Override
    @NotNull
    public PageInfo getPageInfo() {
        return this;
    }

    @Override
    @NotNull
    public Cursor getStartCursor() {
        return this.startCursor;
    }

    @Override
    @NotNull
    public Cursor getEndCursor() {
        return this.endCursor;
    }

    @Override
    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    @Override
    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public static class Builder<T> {
        private final GenericConnection<T> connection;

        public Builder(@NotNull Iterator<T> dataIterator, @NotNull Function<T, String> cursorStringProvider) {
            this.connection = new GenericConnection(dataIterator, cursorStringProvider);
        }

        public Builder<T> withLimit(int limit) {
            if (limit < 0) {
                limit = 0;
            }
            if (limit > 100) {
                throw new IllegalArgumentException("Invalid limit " + limit + ", the maximum value is " + 100);
            }
            ((GenericConnection)this.connection).limit = limit;
            return this;
        }

        public Builder<T> withStartAfter(@Nullable Cursor c) {
            ((GenericConnection)this.connection).startAfter = c;
            return this;
        }

        public Builder<T> withPreviousPage(boolean b) {
            ((GenericConnection)this.connection).hasPreviousPage = b;
            return this;
        }

        public Builder<T> withNextPage(boolean b) {
            ((GenericConnection)this.connection).hasNextPage = b;
            return this;
        }

        public Connection<T> build() {
            ((GenericConnection)this.connection).initialize();
            return this.connection;
        }
    }
}

