/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.support.impl;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(service={HealthCheck.class}, name="org.apache.sling.hc.support.DefaultLoginsHealthCheck", configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class DefaultLoginsHealthCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLoginsHealthCheck.class);
    public static final String HC_LABEL = "Health Check: Default Logins (deprecated)";
    private List<String> logins;
    @Reference
    private SlingRepository repository;

    @Activate
    protected void activate(Config config) {
        this.logins = Arrays.asList(config.logins());
        LOG.info("Activated, logins={}", this.logins);
        LOG.warn("This is deprecated. Please use the component from the org.apache.sling.auth.core bundle instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        int checked = 0;
        int failures = 0;
        for (String login : this.logins) {
            String[] parts = login.split(":");
            if (parts.length != 2) {
                resultLog.warn("Expected login in the form username:password, got [{}]", new Object[]{login});
                continue;
            }
            ++checked;
            String username = parts[0].trim();
            String password = parts[1].trim();
            SimpleCredentials creds = new SimpleCredentials(username, password.toCharArray());
            Session s = null;
            try {
                s = this.repository.login((Credentials)creds);
                if (s != null) {
                    ++failures;
                    resultLog.warn("Login as [{}] succeeded, was expecting it to fail", new Object[]{username});
                    continue;
                }
                resultLog.debug("Login as [{}] didn't throw an Exception but returned null Session", new Object[]{username});
            }
            catch (RepositoryException re) {
                resultLog.debug("Login as [{}] failed, as expected", new Object[]{username});
            }
            finally {
                if (s == null) continue;
                s.logout();
            }
        }
        if (checked == 0) {
            resultLog.warn("Did not check any logins, configured logins={}", new Object[]{this.logins});
        } else if (failures != 0) {
            resultLog.warn("Checked {} logins, {} failures", new Object[]{checked, failures});
        } else {
            resultLog.debug("Checked {} logins, all successful", new Object[]{checked, failures});
        }
        return new Result((ResultLog)resultLog);
    }

    @ObjectClassDefinition(name="Health Check: Default Logins (deprecated)", description="Expects default logins to fail, used to verify that they are disabled on production systems")
    static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check.")
        public String hc_name() default "Default Logins Check";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Default Logins", description="Which credentials to check. Each one is in the format \"user:password\" like \"admin:admin\" for example. Do *not* put any confidential passwords here, the goal is just to check that the default/demo logins, which passwords are known anyway, are disabled.")
        public String[] logins() default {"logins"};

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Default Logins Check (deprecated): {logins}";
    }
}

