/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.data.core.TransactionContext;

public class DefaultISMLocking
implements ISMLocking {
    private final ISMLocking.ReadLock readLock = new ISMLocking.ReadLock(){

        @Override
        public void release() {
            DefaultISMLocking.this.releaseReadLock();
        }
    };
    private final ISMLocking.WriteLock writeLock = new ISMLocking.WriteLock(){

        @Override
        public void release() {
            DefaultISMLocking.this.releaseWriteLock(false);
        }

        @Override
        public ISMLocking.ReadLock downgrade() {
            DefaultISMLocking.this.releaseWriteLock(true);
            return DefaultISMLocking.this.readLock;
        }
    };
    private boolean writerPreference = true;
    private int writersWaiting = 0;
    private Object writerId = null;
    private int writerCount = 0;
    private int readerCount = 0;

    public boolean isWriterPreference() {
        return this.writerPreference;
    }

    public void setWriterPreference(boolean preference) {
        this.writerPreference = preference;
    }

    @Override
    public synchronized ISMLocking.ReadLock acquireReadLock(ItemId id) throws InterruptedException {
        Object currentId = TransactionContext.getCurrentThreadId();
        while (this.writerId != null ? this.writerCount > 0 && !TransactionContext.isSameThreadId(this.writerId, currentId) : this.writerPreference && this.writersWaiting > 0) {
            this.wait();
        }
        ++this.readerCount;
        return this.readLock;
    }

    private synchronized void releaseReadLock() {
        --this.readerCount;
        if (this.readerCount == 0 && this.writerCount == 0) {
            this.writerId = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws InterruptedException {
        Object currentId = TransactionContext.getCurrentThreadId();
        ++this.writersWaiting;
        try {
            while (this.writerId != null ? !TransactionContext.isSameThreadId(this.writerId, currentId) : this.readerCount > 0) {
                this.wait();
            }
        }
        finally {
            --this.writersWaiting;
        }
        if (this.writerCount++ == 0) {
            this.writerId = currentId;
        }
        return this.writeLock;
    }

    private synchronized void releaseWriteLock(boolean downgrade) {
        --this.writerCount;
        if (downgrade) {
            ++this.readerCount;
        }
        if (this.writerCount == 0) {
            if (this.readerCount == 0) {
                this.writerId = null;
            }
            this.notifyAll();
        }
    }
}

