/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.jcr.Session;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.jcr.repoinit.impl.AclVisitor;
import org.apache.sling.jcr.repoinit.impl.GroupMembershipVisitor;
import org.apache.sling.jcr.repoinit.impl.NamespacesVisitor;
import org.apache.sling.jcr.repoinit.impl.NodePropertiesVisitor;
import org.apache.sling.jcr.repoinit.impl.NodeVisitor;
import org.apache.sling.jcr.repoinit.impl.NodetypesVisitor;
import org.apache.sling.jcr.repoinit.impl.PrivilegeVisitor;
import org.apache.sling.jcr.repoinit.impl.RepoInitException;
import org.apache.sling.jcr.repoinit.impl.UserVisitor;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JcrRepoInitOpsProcessor.class}, property={"service.vendor=The Apache Software Foundation"})
public class JcrRepoInitOpsProcessorImpl
implements JcrRepoInitOpsProcessor {
    private static final Logger log = LoggerFactory.getLogger(JcrRepoInitOpsProcessorImpl.class);

    @Override
    public void apply(Session session, List<Operation> ops) {
        AtomicReference<Operation> lastAttemptedOperation = new AtomicReference<Operation>();
        try {
            Stream.of(Collections.singleton(new NamespacesVisitor(session)), Arrays.asList(new NodetypesVisitor(session), new PrivilegeVisitor(session)), Arrays.asList(new UserVisitor(session), new NodeVisitor(session), new AclVisitor(session), new GroupMembershipVisitor(session), new NodePropertiesVisitor(session))).forEach(visitorGroup -> ops.forEach(op -> {
                lastAttemptedOperation.set((Operation)op);
                visitorGroup.forEach(arg_0 -> ((Operation)op).accept(arg_0));
            }));
        }
        catch (RepoInitException originalFailure) {
            JcrRepoInitOpsProcessorImpl.handleLegacyOrderingSupport(session, ops, originalFailure, lastAttemptedOperation);
        }
    }

    private static void handleLegacyOrderingSupport(Session session, List<Operation> ops, RepoInitException originalFailure, AtomicReference<Operation> lastAttemptedOperation) {
        try {
            OperationVisitor[] visitors;
            session.refresh(false);
            for (OperationVisitor v : visitors = new OperationVisitor[]{new NamespacesVisitor(session), new NodetypesVisitor(session), new PrivilegeVisitor(session), new UserVisitor(session), new NodeVisitor(session), new AclVisitor(session), new GroupMembershipVisitor(session), new NodePropertiesVisitor(session)}) {
                for (Operation op : ops) {
                    op.accept(v);
                }
            }
            log.warn("DEPRECATION - The repoinit script being executed relies on a bug causing repoinit statements to be reordered (SLING-12107). For now your repoinit script was applied successfully in legacy mode. Please review and fix the ordering of your repoinit statements to avoid future issues. The code supporting the legacy order will be removed in a future release. The new code failed on the statement \"{}\". The original exception message was: {}", (Object)Optional.ofNullable(lastAttemptedOperation.get()).map(Operation::asRepoInitString).orElse("unknown"), (Object)originalFailure.getMessage());
        }
        catch (Exception legacyFailure) {
            throw originalFailure;
        }
    }
}

