/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.helper;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.CopyMoveManager;
import org.apache.jackrabbit.server.io.DeleteManager;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.PropertyManager;
import org.apache.jackrabbit.webdav.simple.DefaultItemFilter;
import org.apache.jackrabbit.webdav.simple.ItemFilter;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.webdav.impl.helper.SlingTikaDetector;
import org.apache.sling.jcr.webdav.impl.servlets.SlingWebDavServlet;

public class SlingResourceConfig
extends ResourceConfig {
    private final String[] collectionTypes;
    private final ItemFilter itemFilter;
    private final IOManager ioManager;
    private final PropertyManager propertyManager;
    private final CopyMoveManager copyMoveManager;
    private final DeleteManager deleteManager;
    private final String servletContextPath;
    private final Dictionary<String, String> servletInitParams;

    public SlingResourceConfig(MimeTypeService mimeTypeService, SlingWebDavServlet.Config config, IOManager ioManager, PropertyManager propertyManager, CopyMoveManager copyMoveManager, DeleteManager deleteManager) {
        super(new SlingTikaDetector(mimeTypeService));
        this.ioManager = ioManager;
        this.propertyManager = propertyManager;
        this.copyMoveManager = copyMoveManager;
        this.deleteManager = deleteManager;
        this.collectionTypes = config.collection_types();
        String[] filterPrefixes = config.filter_prefixes();
        String[] filterNodeTypes = config.filter_types();
        String[] filterURIs = config.filter_uris();
        this.itemFilter = new DefaultItemFilter();
        this.itemFilter.setFilteredPrefixes(filterPrefixes);
        this.itemFilter.setFilteredURIs(filterURIs);
        this.itemFilter.setFilteredNodetypes(filterNodeTypes);
        this.servletContextPath = config.dav_root();
        this.servletInitParams = new Hashtable<String, String>();
        this.servletInitParams.put("resource-path-prefix", this.servletContextPath);
        String value = config.dav_realm();
        this.servletInitParams.put("authenticate-header", "Basic realm=\"" + value + "\"");
        boolean createAbsoluteUri = config.dav_create$_$absolute$_$uri();
        this.servletInitParams.put("createAbsoluteURI", Boolean.toString(createAbsoluteUri));
    }

    @Override
    public IOManager getIOManager() {
        return this.ioManager;
    }

    @Override
    public ItemFilter getItemFilter() {
        return this.itemFilter;
    }

    @Override
    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    @Override
    public CopyMoveManager getCopyMoveManager() {
        return this.copyMoveManager;
    }

    @Override
    public DeleteManager getDeleteManager() {
        return this.deleteManager;
    }

    @Override
    public boolean isCollectionResource(Item item) {
        if (item.isNode()) {
            Node node = (Node)item;
            for (String type : this.collectionTypes) {
                try {
                    if (node.isNodeType(type)) {
                        return false;
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    @Override
    public void parse(URL configURL) {
    }

    public String getServletContextPath() {
        return this.servletContextPath;
    }

    public Dictionary<String, String> getServletInitParams() {
        return this.servletInitParams;
    }
}

