/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.jcr;

import java.io.IOException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={Servlet.class}, property={"service.description:String=FullText Query Servlet", "service.vendor:String=The Apache Software Foundation", "sling.servlet.paths:String=/testing/fullTextQuery"})
public class FullTextQueryServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        String queryText = request.getParameter("q");
        if (queryText == null || queryText.isEmpty()) {
            response.setStatus(400);
            response.getWriter().write("Missing mandatory 'q' parameter");
            return;
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        try {
            Query query = session.getWorkspace().getQueryManager().createQuery("SELECT * FROM [nt:base] AS s WHERE CONTAINS(s.*, $queryText)", "JCR-SQL2");
            query.bindValue("queryText", session.getValueFactory().createValue(queryText));
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            while (iterator.hasNext()) {
                response.getWriter().println(iterator.nextNode().getPath());
            }
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

