/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.sling.nosql.generic.adapter.MapConverter;
import org.junit.Assert;
import org.junit.Test;

public class MapConverterTest {
    @Test
    public void testMapArrayToList() throws Exception {
        Map result = MapConverter.mapArrayToList((Map)Maps.newHashMap((Map)ImmutableMap.builder().put((Object)"prop1", (Object)"value1").put((Object)"prop2", (Object)2).put((Object)"stringArray", (Object)new String[]{"value1", "value2"}).put((Object)"integerArray", (Object)new Integer[]{1, 2, 3}).put((Object)"integerArray2", (Object)new int[]{1, 2, 3}).put((Object)"longArray", (Object)new long[]{1L, 2L}).put((Object)"doubleArray", (Object)new double[]{1.1, 1.2}).put((Object)"booleanArray", (Object)new boolean[]{true, false}).build()));
        Assert.assertEquals((String)"prop1", (Object)"value1", result.get("prop1"));
        Assert.assertEquals((String)"prop2", (Object)2, result.get("prop2"));
        Assert.assertEquals((String)"stringArray", (Object)ImmutableList.of((Object)"value1", (Object)"value2"), result.get("stringArray"));
        Assert.assertEquals((String)"integerArray", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3), result.get("integerArray"));
        Assert.assertEquals((String)"integerArray2", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3), result.get("integerArray2"));
        Assert.assertEquals((String)"longArray", (Object)ImmutableList.of((Object)1L, (Object)2L), result.get("longArray"));
        Assert.assertEquals((String)"doubleArray", (Object)ImmutableList.of((Object)1.1, (Object)1.2), result.get("doubleArray"));
        Assert.assertEquals((String)"booleanArray", (Object)ImmutableList.of((Object)true, (Object)false), result.get("booleanArray"));
    }

    @Test
    public void testMapListToArray() throws Exception {
        Map result = MapConverter.mapListToArray((Map)Maps.newHashMap((Map)ImmutableMap.builder().put((Object)"prop1", (Object)"value1").put((Object)"prop2", (Object)2).put((Object)"stringArray", (Object)ImmutableList.of((Object)"value1", (Object)"value2")).put((Object)"integerArray", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)).put((Object)"longArray", (Object)ImmutableList.of((Object)1L, (Object)2L)).put((Object)"doubleArray", (Object)ImmutableList.of((Object)1.1, (Object)1.2)).put((Object)"booleanArray", (Object)ImmutableList.of((Object)true, (Object)false)).build()));
        Assert.assertEquals((String)"prop1", (Object)"value1", result.get("prop1"));
        Assert.assertEquals((String)"prop2", (Object)2, result.get("prop2"));
        Assert.assertArrayEquals((String)"stringArray", (Object[])new String[]{"value1", "value2"}, (Object[])((String[])result.get("stringArray")));
        Assert.assertArrayEquals((String)"integerArray", (Object[])new Integer[]{1, 2, 3}, (Object[])((Integer[])result.get("integerArray")));
        Assert.assertArrayEquals((String)"longArray", (Object[])new Long[]{1L, 2L}, (Object[])((Long[])result.get("longArray")));
        Assert.assertArrayEquals((String)"doubleArray", (Object[])new Double[]{1.1, 1.2}, (Object[])((Double[])result.get("doubleArray")));
        Assert.assertArrayEquals((String)"booleanArray", (Object[])new Boolean[]{true, false}, (Object[])((Boolean[])result.get("booleanArray")));
    }
}

