/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.resource.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.nosql.generic.resource.impl.NoSqlResource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractNoSqlResourceProviderRootTest {
    @Rule
    public SlingContext context = new SlingContext(ResourceResolverType.NONE);

    protected abstract void registerResourceProviderFactoryAsRoot();

    @Before
    public void setUp() throws Exception {
        this.registerResourceProviderFactoryAsRoot();
    }

    @After
    public void tearDown() {
        this.context.resourceResolver().revert();
    }

    @Test
    public void testRoot() {
        Resource root = this.context.resourceResolver().getResource("/");
        Assert.assertNotNull((Object)root);
        Assert.assertTrue((boolean)(root instanceof NoSqlResource));
    }

    @Test
    public void testCreatePath() throws PersistenceException {
        ResourceUtil.getOrCreateResource((ResourceResolver)this.context.resourceResolver(), (String)"/test/test1", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:unstructured"), (String)"nt:unstructured", (boolean)true);
        Resource test = this.context.resourceResolver().getResource("/test");
        Assert.assertNotNull((Object)test);
        Resource test1 = this.context.resourceResolver().getResource("/test/test1");
        Assert.assertNotNull((Object)test1);
        this.context.resourceResolver().delete(test);
    }

    @Test
    public void testListChildren_RootNode() throws IOException {
        Resource testResource = ResourceUtil.getOrCreateResource((ResourceResolver)this.context.resourceResolver(), (String)"/test", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:unstructured"), (String)"nt:unstructured", (boolean)true);
        Resource root = this.context.resourceResolver().getResource("/");
        ArrayList children = Lists.newArrayList((Iterator)root.listChildren());
        Assert.assertFalse((boolean)children.isEmpty());
        Assert.assertTrue((boolean)this.containsResource(children, testResource));
        children = Lists.newArrayList((Iterable)root.getChildren());
        Assert.assertFalse((boolean)children.isEmpty());
        Assert.assertTrue((boolean)this.containsResource(children, testResource));
        this.context.resourceResolver().delete(testResource);
    }

    private boolean containsResource(List<Resource> children, Resource resource) {
        for (Resource child : children) {
            if (!StringUtils.equals((CharSequence)child.getPath(), (CharSequence)resource.getPath())) continue;
            return true;
        }
        return false;
    }

    @Test(expected=PersistenceException.class)
    public void testDeleteRootPath() throws PersistenceException {
        Resource root = this.context.resourceResolver().getResource("/");
        this.context.resourceResolver().delete(root);
    }

    @Test
    public void testUpdateRootPath() throws PersistenceException {
        Resource root = this.context.resourceResolver().getResource("/");
        ModifiableValueMap props = (ModifiableValueMap)root.adaptTo(ModifiableValueMap.class);
        props.put((Object)"prop1", (Object)"value1");
        this.context.resourceResolver().commit();
        root = this.context.resourceResolver().getResource("/");
        Assert.assertThat((Object)root.getValueMap().get("prop1", String.class), (Matcher)CoreMatchers.equalTo((Object)"value1"));
    }
}

