/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.adapter;

import aQute.bnd.annotation.ProviderType;
import java.util.Map;
import org.apache.sling.nosql.generic.adapter.MapConverter;
import org.apache.sling.nosql.generic.adapter.MultiValueMode;

@ProviderType
public final class NoSqlData {
    private final String path;
    private final Map<String, Object> properties;

    public NoSqlData(String path, Map<String, Object> properties) {
        this(path, properties, MultiValueMode.ARRAYS);
    }

    public NoSqlData(String path, Map<String, Object> properties, MultiValueMode multiValueMode) {
        this.path = path;
        switch (multiValueMode) {
            case ARRAYS: {
                this.properties = properties;
                break;
            }
            case LISTS: {
                this.properties = MapConverter.mapListToArray(properties);
                break;
            }
            default: {
                throw new IllegalArgumentException("Multi value mode not supported: " + (Object)((Object)multiValueMode));
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, Object> getProperties() {
        return this.getProperties(MultiValueMode.ARRAYS);
    }

    public Map<String, Object> getProperties(MultiValueMode multiValueMode) {
        switch (multiValueMode) {
            case ARRAYS: {
                return this.properties;
            }
            case LISTS: {
                return MapConverter.mapArrayToList(this.properties);
            }
        }
        throw new IllegalArgumentException("Multi value mode not supported: " + (Object)((Object)multiValueMode));
    }
}

