/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.Collections;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PathSegmentDefinition {
    private final String segment;
    private final String primaryType;
    private final List<String> mixins;
    private final boolean isDefaultPrimary;

    public PathSegmentDefinition(String segment, String primaryType) {
        this(segment, primaryType, null, false);
    }

    public PathSegmentDefinition(String segment, String primaryType, List<String> mixins) {
        this(segment, primaryType, mixins, false);
    }

    public PathSegmentDefinition(String segment, String primaryType, boolean isDefaultPrimary) {
        this(segment, primaryType, null, isDefaultPrimary);
    }

    public PathSegmentDefinition(String segment, String primaryType, List<String> mixins, boolean isDefaultPrimary) {
        this.segment = segment;
        this.primaryType = primaryType;
        this.mixins = mixins == null ? Collections.emptyList() : mixins;
        this.isDefaultPrimary = isDefaultPrimary;
    }

    public String toString() {
        boolean hasMixin;
        StringBuilder sb = new StringBuilder();
        sb.append(this.segment);
        boolean hasPrimaryType = this.primaryType != null;
        boolean bl = hasMixin = !this.mixins.isEmpty();
        if (hasPrimaryType || hasMixin) {
            sb.append("(");
            if (hasPrimaryType) {
                sb.append(this.primaryType);
            }
            if (hasPrimaryType && hasMixin) {
                sb.append(" ");
            }
            if (hasMixin) {
                sb.append("mixin ");
                sb.append(this.mixins.toString());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getSegment() {
        return this.segment;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public List<String> getMixins() {
        return this.mixins;
    }

    public boolean isDefaultPrimary() {
        return this.isDefaultPrimary;
    }
}

