/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.sample.slingshot.model;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public abstract class PropertiesSupport {

    protected final Resource resource;

    private volatile ValueMap properties;

    public PropertiesSupport(final Resource resource) {
        this.resource = resource;
    }

    protected ValueMap getProperties() {
        if ( this.properties == null ) {
            if ( this.resource == null ) {
                this.properties = ResourceUtil.getValueMap(null);
            } else {
                this.properties = resource.getValueMap();
            }
        }
        return this.properties;
    }

}
