/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.helper;

import jakarta.servlet.ServletRequest;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

class OnDemandReaderJakarta
extends Reader {
    private final ServletRequest request;
    private Reader delegatee;

    OnDemandReaderJakarta(ServletRequest request) {
        this.request = request;
    }

    @Override
    public void close() throws IOException {
        if (this.delegatee != null) {
            this.delegatee.close();
        }
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.getReader().mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegatee != null && this.delegatee.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.getReader().read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.getReader().read(cbuf, off, len);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.getReader().read(cbuf);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.getReader().read(target);
    }

    @Override
    public boolean ready() throws IOException {
        return this.getReader().ready();
    }

    @Override
    public void reset() throws IOException {
        if (this.delegatee != null) {
            this.delegatee.reset();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getReader().skip(n);
    }

    private Reader getReader() throws IOException {
        if (this.delegatee == null) {
            this.delegatee = this.request.getReader();
        }
        return this.delegatee;
    }
}

