/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.freemarker.internal;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.util.List;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TemplateModel.class}, property={"namespace=sling", "name=adaptTo"})
public class AdaptToMethod
implements TemplateMethodModelEx {
    @Reference
    private AdapterManager adapterManager;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 2) {
            throw new TemplateModelException("wrong number of arguments, expecting 2 (adaptable and adapter type).");
        }
        try {
            String classname = arguments.get(1).toString();
            Class<?> clazz = this.dynamicClassLoaderManager.getDynamicClassLoader().loadClass(classname);
            TemplateModel templateModel = (TemplateModel)arguments.get(0);
            Object adaptable = DeepUnwrap.unwrap((TemplateModel)templateModel);
            return this.adapterManager.getAdapter(adaptable, clazz);
        }
        catch (Exception e) {
            throw new TemplateModelException(e);
        }
    }
}

