/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={SightlyEngineConfiguration.class}, configurationPid={"org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration"})
@Designate(ocd=Configuration.class)
public class SightlyEngineConfiguration {
    private String engineVersion = "0";
    private boolean keepGenerated;
    private String bundleSymbolicName = "org.apache.sling.scripting.sightly";
    private Set<String> allowedExpressionOptions;
    private boolean legacyBooleanCasting;
    private int scriptResolutionCacheSize = 0;
    public static final boolean LEGACY_BOOLEAN_CASTING_DEFAULT = true;

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getScratchFolder() {
        return "/" + this.bundleSymbolicName.replaceAll("\\.", "/");
    }

    public boolean keepGenerated() {
        return this.keepGenerated;
    }

    public Set<String> getAllowedExpressionOptions() {
        return this.allowedExpressionOptions;
    }

    public boolean legacyBooleanCasting() {
        return this.legacyBooleanCasting;
    }

    public int getScriptResolutionCacheSize() {
        return this.scriptResolutionCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(Configuration configuration) {
        InputStream ins = null;
        try {
            ins = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
            if (ins != null) {
                String symbolicName;
                Manifest manifest = new Manifest(ins);
                Attributes attrs = manifest.getMainAttributes();
                String version = attrs.getValue("ScriptEngine-Version");
                if (version != null) {
                    this.engineVersion = version;
                }
                if (StringUtils.isNotEmpty((CharSequence)(symbolicName = attrs.getValue("Bundle-SymbolicName")))) {
                    this.bundleSymbolicName = symbolicName;
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.keepGenerated = configuration.keepGenerated();
        this.allowedExpressionOptions = new HashSet<String>(Arrays.asList(configuration.allowedExpressionOptions()));
        this.legacyBooleanCasting = configuration.legacyBooleanCasting();
        this.scriptResolutionCacheSize = configuration.scriptResolutionCacheSize();
    }

    @ObjectClassDefinition(name="Apache Sling Scripting HTL Engine Configuration")
    static @interface Configuration {
        @AttributeDefinition(name="Keep Generated Java Source Code", description="If enabled, the Java source code generated during HTL template files compilation will be stored. Its location is dependent on the available org.apache.sling.commons.classloader.ClassLoaderWriter.")
        public boolean keepGenerated() default true;

        @AttributeDefinition(name="Known Expression Options", description="A list of extra expression options that should be ignored by the HTL compiler when reporting unknown options.")
        public String[] allowedExpressionOptions();

        @AttributeDefinition(name="Legacy boolean casting", description="When the legacy boolean casting is enabled, the string 'false', irrespective of its casing, will be casted to the Boolean false. So will objects whose implementation of the toString() method returns the string 'false'. This is a violation of the HTL specification, but the HTL implementation worked like this from its inception.")
        public boolean legacyBooleanCasting() default true;

        @AttributeDefinition(name="Script Resolution Cache Size", description="The Script Resolution Cache allows caching script dependencies resolution based on the the script caller, reducing the number of resource tree lookups. A value lower than 1024 disables the cache.")
        public int scriptResolutionCacheSize() default 0;
    }
}

