/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.sitemap.SitemapException;
import org.apache.sling.sitemap.SitemapGeneratorManager;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.builder.Sitemap;
import org.apache.sling.sitemap.builder.Url;
import org.apache.sling.sitemap.impl.SitemapServiceConfiguration;
import org.apache.sling.sitemap.impl.SitemapStorage;
import org.apache.sling.sitemap.impl.builder.SitemapImpl;
import org.apache.sling.sitemap.impl.builder.extensions.ExtensionProviderManager;
import org.apache.sling.sitemap.spi.generator.SitemapGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class}, property={"job.topics=org/apache/sling/sitemap/build"})
@Designate(ocd=Configuration.class)
public class SitemapGeneratorExecutor
implements JobExecutor {
    static final String JOB_TOPIC = "org/apache/sling/sitemap/build";
    static final String JOB_PROPERTY_SITEMAP_ROOT = "sitemap.root";
    static final String JOB_PROPERTY_SITEMAP_NAME = "sitemap.name";
    private static final Logger LOG = LoggerFactory.getLogger(SitemapGeneratorExecutor.class);
    private static final Map<String, Object> AUTH = Collections.singletonMap("sling.service.subservice", "sitemap-reader");
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SitemapGeneratorManager generatorManager;
    @Reference
    private ExtensionProviderManager extensionProviderManager;
    @Reference
    private SitemapStorage storage;
    @Reference(target="(subServiceName=sitemap-reader)")
    private ServiceUserMapped serviceUserMapped;
    @Reference
    private SitemapServiceConfiguration configuration;
    private int chunkSize = 10;

    @Activate
    protected void activate(Configuration configuration) {
        this.chunkSize = configuration.chunkSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobExecutionResult process(Job job, JobExecutionContext context) {
        String sitemapRootPath = (String)job.getProperty(JOB_PROPERTY_SITEMAP_ROOT, String.class);
        String sitemapName = (String)job.getProperty(JOB_PROPERTY_SITEMAP_NAME, (Object)"<default>");
        JobExecutionContext.ResultBuilder result = context.result();
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Resource sitemapRoot = SitemapUtil.normalizeSitemapRoot(resourceResolver.getResource(sitemapRootPath));
            if (sitemapRoot == null) {
                JobExecutionResult jobExecutionResult = result.message("Cannot find sitemap root at: " + sitemapRootPath).cancelled();
                return jobExecutionResult;
            }
            SitemapGenerator generator = this.generatorManager.getGenerator(sitemapRoot, sitemapName);
            if (generator == null) {
                JobExecutionResult jobExecutionResult = result.message("Generator of '" + sitemapName + "' unavailable at: " + sitemapRootPath).failed();
                return jobExecutionResult;
            }
            this.generate(sitemapRoot, sitemapName, generator, context);
            JobExecutionResult jobExecutionResult = result.succeeded();
            return jobExecutionResult;
        }
        catch (LoginException ex) {
            LOG.warn("Failed to login service user for sitemap generation", (Throwable)ex);
            return result.message(ex.getMessage()).cancelled();
        }
        catch (IOException | SitemapException ex) {
            LOG.error("Failed to write sitemap", (Throwable)ex);
            return result.message(ex.getMessage()).failed();
        }
    }

    private void generate(Resource res, String name, SitemapGenerator generator, JobExecutionContext jobCtxt) throws SitemapException, IOException {
        try {
            CopyableByteArrayOutputStream buffer = new CopyableByteArrayOutputStream();
            Context genCtxt = new Context();
            ValueMap state = this.storage.getState(res, name);
            InputStream existingData = (InputStream)state.get("jcr:data", InputStream.class);
            if (existingData != null) {
                IOUtils.copy((InputStream)existingData, (OutputStream)buffer);
            }
            for (Map.Entry entry : state.entrySet()) {
                if (((String)entry.getKey()).indexOf(58) >= 0) continue;
                genCtxt.data.put((Object)((String)entry.getKey()), entry.getValue());
            }
            int fileIndex = (Integer)state.get("sling:sitemapFileIndex", (Object)1);
            int urlCount = (Integer)state.get("sling:sitemapEntries", (Object)0);
            MultiFileSitemap sitemap = new MultiFileSitemap(res, name, fileIndex, buffer, genCtxt, jobCtxt);
            sitemap.currentSitemap.urlCount = urlCount;
            generator.generate(res, name, sitemap, genCtxt);
            sitemap.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generated sitemaps: {}", (Object)String.join((CharSequence)", ", sitemap.files));
            }
            Collection<String> purgedFiles = this.storage.deleteSitemaps(res, name, i -> i.getFileIndex() >= sitemap.fileIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Purged obsolete sitemaps: {}", (Object)String.join((CharSequence)", ", purgedFiles));
            }
        }
        catch (JobAbandonedException ex) {
            throw ex;
        }
        catch (JobStoppedException ex) {
            LOG.debug("Job stopped, removing state", (Throwable)ex);
            this.storage.deleteState(res, name);
        }
        catch (IOException | RuntimeException | SitemapException ex) {
            this.storage.deleteState(res, name);
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            if (ex instanceof RuntimeException) {
                throw new SitemapException(ex);
            }
            throw ex;
        }
    }

    private static class Context
    implements SitemapGenerator.Context {
        private final ValueMap data = new ValueMapDecorator(new HashMap());

        private Context() {
        }

        @Override
        @Nullable
        public <T> T getProperty(@NotNull String name, @NotNull Class<T> cls) {
            return (T)this.data.get(name, cls);
        }

        @Override
        @NotNull
        public <T> T getProperty(@NotNull String name, @NotNull T defaultValue) {
            return (T)this.data.get(name, defaultValue);
        }

        @Override
        public void setProperty(@NotNull String name, @Nullable Object data) {
            if (name.indexOf(58) >= 0) {
                return;
            }
            this.data.put((Object)name, data);
        }
    }

    private class StatefulSitemap
    extends SitemapImpl {
        private final Resource sitemapRoot;
        private final String name;
        private final CopyableByteArrayOutputStream buffer;
        private final JobExecutionContext jobContext;
        private final Context generatorContext;
        private int urlCount;
        private int writtenUrls;

        StatefulSitemap(Resource sitemapRoot, String name, CopyableByteArrayOutputStream buffer, JobExecutionContext jobContext, Context generatorContext) throws IOException {
            super(new OutputStreamWriter((OutputStream)buffer, StandardCharsets.UTF_8), SitemapGeneratorExecutor.this.extensionProviderManager, buffer.size() == 0);
            this.urlCount = 0;
            this.writtenUrls = 0;
            this.sitemapRoot = sitemapRoot;
            this.name = name;
            this.buffer = buffer;
            this.jobContext = jobContext;
            this.generatorContext = generatorContext;
        }

        @Override
        @NotNull
        public Url addUrl(@NotNull String location) throws SitemapException {
            if (this.jobContext.isStopped()) {
                throw new JobStoppedException();
            }
            Url url = super.addUrl(location);
            ++this.urlCount;
            return url;
        }

        @Override
        protected boolean writePendingUrl() throws SitemapException {
            boolean written = super.writePendingUrl();
            if (written && ++this.writtenUrls == SitemapGeneratorExecutor.this.chunkSize) {
                try {
                    this.out.flush();
                    HashMap<String, Object> copy = new HashMap<String, Object>(this.generatorContext.data.size() + 1);
                    copy.putAll((Map<String, Object>)this.generatorContext.data);
                    copy.put("sling:sitemapEntries", this.urlCount);
                    copy.put("jcr:data", this.buffer.copy());
                    SitemapGeneratorExecutor.this.storage.writeState(this.sitemapRoot, this.name, copy);
                    this.writtenUrls = 0;
                }
                catch (IOException ex) {
                    throw new SitemapException(ex);
                }
            }
            return written;
        }
    }

    private class MultiFileSitemap
    implements Sitemap,
    Closeable {
        private final Resource sitemapRoot;
        private final String name;
        private final JobExecutionContext jobContext;
        private final Context generatorContext;
        private final List<String> files = new ArrayList<String>(1);
        private final CopyableByteArrayOutputStream buffer;
        private final CopyableByteArrayOutputStream overflowBuffer = new CopyableByteArrayOutputStream();
        private int fileIndex;
        private StatefulSitemap currentSitemap;

        MultiFileSitemap(Resource sitemapRoot, String name, int fileIndex, CopyableByteArrayOutputStream buffer, Context generatorContext, JobExecutionContext jobContext) throws IOException {
            this.sitemapRoot = sitemapRoot;
            this.name = name;
            this.fileIndex = fileIndex;
            this.buffer = buffer;
            this.jobContext = jobContext;
            this.generatorContext = generatorContext;
            this.currentSitemap = this.newSitemap();
        }

        @Override
        @NotNull
        public Url addUrl(@NotNull String location) throws SitemapException {
            try {
                this.rotateIfNecessary();
            }
            catch (IOException ex) {
                throw new SitemapException(ex);
            }
            return this.currentSitemap.addUrl(location);
        }

        @Override
        public void close() throws IOException {
            this.rotateIfNecessary();
            this.closeSitemap();
        }

        private StatefulSitemap newSitemap() throws IOException {
            return new StatefulSitemap(this.sitemapRoot, this.name, this.buffer, this.jobContext, this.generatorContext);
        }

        private void closeSitemap() throws IOException {
            this.currentSitemap.close();
            int urlCount = this.currentSitemap.urlCount;
            if (urlCount == 0) {
                return;
            }
            String path = SitemapGeneratorExecutor.this.storage.writeSitemap(this.sitemapRoot, this.name, this.buffer.copy(), this.fileIndex, this.buffer.size(), urlCount);
            this.generatorContext.data.put((Object)"sling:sitemapFileIndex", (Object)(++this.fileIndex));
            this.files.add(path);
        }

        private boolean rotateIfNecessary() throws IOException {
            this.buffer.createCheckpoint();
            this.currentSitemap.flush();
            if (this.buffer.size() + 10 > SitemapGeneratorExecutor.this.configuration.getMaxSize()) {
                this.overflowBuffer.reset();
                IOUtils.copy((InputStream)this.buffer.copyAfterCheckpoint(), (OutputStream)this.overflowBuffer);
                this.buffer.rollback();
                this.currentSitemap.urlCount--;
                this.rotateSitemap();
                this.currentSitemap.flush();
                IOUtils.copy((InputStream)this.overflowBuffer.copy(), (OutputStream)this.buffer);
                this.currentSitemap.urlCount++;
                return true;
            }
            if (this.currentSitemap.urlCount + 1 > SitemapGeneratorExecutor.this.configuration.getMaxEntries()) {
                this.rotateSitemap();
                return true;
            }
            return false;
        }

        private void rotateSitemap() throws IOException {
            this.closeSitemap();
            this.buffer.reset();
            this.currentSitemap = this.newSitemap();
        }
    }

    protected static class JobAbandonedException
    extends RuntimeException {
        JobAbandonedException() {
            super("Abandoned");
        }
    }

    private static class JobStoppedException
    extends RuntimeException {
        JobStoppedException() {
            super("Stopped");
        }
    }

    private static class CopyableByteArrayOutputStream
    extends ByteArrayOutputStream {
        private int checkpoint = -1;

        private CopyableByteArrayOutputStream() {
        }

        private void createCheckpoint() {
            this.checkpoint = this.count;
        }

        private void rollback() {
            this.ensureCheckpoint();
            this.count = this.checkpoint;
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.checkpoint = -1;
        }

        private InputStream copyAfterCheckpoint() {
            this.ensureCheckpoint();
            return new ByteBufferInputStream(ByteBuffer.wrap(this.buf, this.checkpoint, this.size() - this.checkpoint));
        }

        private InputStream copy() {
            return new ByteBufferInputStream(ByteBuffer.wrap(this.buf, 0, this.size()));
        }

        private void ensureCheckpoint() {
            if (this.checkpoint < 0) {
                throw new IllegalStateException("no checkpoint");
            }
        }
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte @NotNull [] bytes, int off, int len) {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }

    @ObjectClassDefinition(name="Apache Sling Sitemap - Background Generator")
    static @interface Configuration {
        @AttributeDefinition(name="Chunk size", description="If set to a positive integer, the background job writes incomplete sitemaps after the given number of urls to the repository and persists progress. This allows the job to be interrupted and resumed.")
        public int chunkSize() default 0x7FFFFFFF;
    }
}

