/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.sitemap.SitemapGeneratorManager;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.impl.SitemapEventUtil;
import org.apache.sling.sitemap.impl.SitemapStorageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapStorage.class, Runnable.class}, property={"scheduler.name=sitemap-storage-cleanup", "scheduler.concurrent:Boolean=false", "scheduler.runOn=SINGLE", "scheduler.threadPool=org-apache-sling-sitemap"})
@Designate(ocd=Configuration.class)
public class SitemapStorage
implements Runnable {
    static final String PN_SITEMAP_ENTRIES = "sling:sitemapEntries";
    static final String PN_SITEMAP_SIZE = "sling:sitemapFileSize";
    static final String PN_SITEMAP_NAME = "sling:sitemapName";
    static final String PN_SITEMAP_FILE_INDEX = "sling:sitemapFileIndex";
    private static final Logger LOG = LoggerFactory.getLogger(SitemapStorage.class);
    private static final Map<String, Object> AUTH = Collections.singletonMap("sling.service.subservice", "sitemap-writer");
    private static final String STATE_EXTENSION = ".part";
    private static final String XML_EXTENSION = ".xml";
    private static final String RT_SITEMAP_PART = "sling/sitemap/part";
    private static final String RT_SITEMAP_FILE = "sling/sitemap/file";
    private static final String PN_RESOURCE_TYPE = "sling:resourceType";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(target="(subServiceName=sitemap-writer)")
    private ServiceUserMapped serviceUserMapped;
    @Reference
    private SitemapGeneratorManager generatorManager;
    @Reference
    private EventAdmin eventAdmin;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private MetricsService metricsService;
    private String rootPath;
    private int maxStateAge = Integer.MAX_VALUE;
    private Counter checkpointReadsExpired;
    private Counter checkpointReads;
    private Counter checkpointMisses;
    private Counter checkpointWrites;

    @Activate
    protected void activate(Configuration configuration) {
        this.rootPath = configuration.storagePath();
        this.maxStateAge = configuration.stateMaxAge();
        if (this.metricsService == null) {
            this.metricsService = MetricsService.NOOP;
        }
        this.checkpointReadsExpired = this.metricsService.counter("SitemapStorage-checkpointReadsExpired");
        this.checkpointMisses = this.metricsService.counter("SitemapStorage-checkpointMisses");
        this.checkpointReads = this.metricsService.counter("SitemapStorage-checkpointReads");
        this.checkpointWrites = this.metricsService.counter("SitemapStorage-checkpointWrites");
    }

    @Override
    public void run() {
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Iterator descendants = SitemapStorage.traverse(resolver.getResource(this.rootPath)).iterator();
            LinkedList<Resource> toDelete = new LinkedList<Resource>();
            LinkedList<Event> purgeEvents = new LinkedList<Event>();
            while (descendants.hasNext()) {
                Resource descendant = (Resource)descendants.next();
                if (descendant.isResourceType(RT_SITEMAP_PART) && this.isExpired(descendant)) {
                    toDelete.add(descendant);
                    continue;
                }
                if (!descendant.isResourceType(RT_SITEMAP_FILE) || this.doesSitemapRootExist(descendant) && SitemapStorage.isValidSitemapFile(descendant)) continue;
                toDelete.add(descendant);
                purgeEvents.add(SitemapEventUtil.newPurgeEvent(descendant.getPath()));
            }
            for (Resource resource : toDelete) {
                LOG.debug("Purging: {}", (Object)resource.getPath());
                resolver.delete(resource);
            }
            resolver.commit();
            purgeEvents.forEach(arg_0 -> ((EventAdmin)this.eventAdmin).postEvent(arg_0));
        }
        catch (LoginException | PersistenceException ex) {
            LOG.warn("Failed to cleanup storage: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ValueMap getState(@NotNull Resource sitemapRoot, @NotNull String name) throws IOException {
        String statePath = this.getSitemapFilePath(sitemapRoot, name) + STATE_EXTENSION;
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Resource state = resolver.getResource(statePath);
            if (state == null) {
                this.checkpointMisses.increment();
                ValueMap valueMap = ValueMap.EMPTY;
                return valueMap;
            }
            if (this.isExpired(state)) {
                this.checkpointReadsExpired.increment();
                ValueMap valueMap = ValueMap.EMPTY;
                return valueMap;
            }
            this.checkpointReads.increment();
            ValueMapDecorator valueMapDecorator = new ValueMapDecorator(new HashMap(state.getValueMap()));
            return valueMapDecorator;
        }
        catch (LoginException ex) {
            throw new IOException("Cannot read state at " + statePath, ex);
        }
    }

    public void writeState(@NotNull Resource sitemapRoot, @NotNull String name, @NotNull Map<String, Object> state) throws IOException {
        String statePath = this.getSitemapFilePath(sitemapRoot, name) + STATE_EXTENSION;
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Resource folder = SitemapStorage.getOrCreateFolder(resolver, ResourceUtil.getParent((String)statePath));
            String stateName = ResourceUtil.getName((String)statePath);
            Resource stateResource = folder.getChild(stateName);
            if (stateResource == null) {
                HashMap<String, Object> properties = new HashMap<String, Object>(state.size() + 1);
                properties.putAll(state);
                properties.put("jcr:primaryType", "nt:unstructured");
                properties.put("jcr:lastModified", Calendar.getInstance());
                properties.put(PN_RESOURCE_TYPE, RT_SITEMAP_PART);
                resolver.create(folder, stateName, properties);
            } else {
                ModifiableValueMap properties = (ModifiableValueMap)stateResource.adaptTo(ModifiableValueMap.class);
                if (properties == null) {
                    throw new IOException("Cannot modify properties of existing state: " + statePath);
                }
                properties.putAll(state);
                properties.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
            }
            this.checkpointWrites.increment();
            resolver.commit();
        }
        catch (LoginException | PersistenceException ex) {
            throw new IOException("Cannot create state at " + statePath, ex);
        }
    }

    public void deleteState(@NotNull Resource sitemapRoot, @NotNull String name) throws IOException {
        String statePath = this.getSitemapFilePath(sitemapRoot, name) + STATE_EXTENSION;
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Resource stateResource = resolver.getResource(statePath);
            if (stateResource != null) {
                resolver.delete(stateResource);
                resolver.commit();
            }
        }
        catch (LoginException | PersistenceException ex) {
            throw new IOException("Cannot create state at " + statePath, ex);
        }
    }

    public String writeSitemap(@NotNull Resource sitemapRoot, @NotNull String name, @NotNull InputStream data, int index, int size, int entries) throws IOException {
        if (index < 1) {
            throw new IllegalArgumentException("only unsigned integer greater then zero permitted");
        }
        String sitemapFilePath = this.getSitemapFilePath(sitemapRoot, name);
        String statePath = sitemapFilePath + STATE_EXTENSION;
        sitemapFilePath = sitemapFilePath + (index > 1 ? "-" + index + XML_EXTENSION : XML_EXTENSION);
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            ModifiableValueMap properties;
            String sitemapFileName = ResourceUtil.getName((String)sitemapFilePath);
            Resource folder = SitemapStorage.getOrCreateFolder(resolver, ResourceUtil.getParent((String)sitemapFilePath));
            Resource sitemapResource = folder.getChild(sitemapFileName);
            if (sitemapResource == null) {
                properties = new HashMap(3);
                properties.put("jcr:primaryType", "nt:unstructured");
                properties.put("jcr:lastModified", Calendar.getInstance());
                properties.put("jcr:data", data);
                properties.put(PN_SITEMAP_NAME, name);
                properties.put(PN_SITEMAP_FILE_INDEX, index);
                properties.put(PN_SITEMAP_ENTRIES, entries);
                properties.put(PN_SITEMAP_SIZE, size);
                properties.put(PN_RESOURCE_TYPE, RT_SITEMAP_FILE);
                sitemapResource = resolver.create(folder, sitemapFileName, (Map)properties);
            } else {
                properties = (ModifiableValueMap)sitemapResource.adaptTo(ModifiableValueMap.class);
                if (properties == null) {
                    throw new IOException("Cannot overwrite existing sitemap at: " + sitemapFilePath);
                }
                properties.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
                properties.put((Object)"jcr:data", (Object)data);
                properties.put((Object)PN_SITEMAP_ENTRIES, (Object)entries);
                properties.put((Object)PN_SITEMAP_SIZE, (Object)size);
            }
            Resource stateResource = resolver.getResource(statePath);
            if (stateResource != null) {
                resolver.delete(stateResource);
            }
            resolver.commit();
            this.eventAdmin.postEvent(SitemapEventUtil.newUpdateEvent(SitemapStorage.newSitemapStorageInfo(sitemapResource), sitemapRoot));
        }
        catch (LoginException | PersistenceException ex) {
            throw new IOException("Cannot create sitemap at " + sitemapFilePath, ex);
        }
        return sitemapFilePath;
    }

    public Collection<String> deleteSitemaps(@NotNull Resource sitemapRoot, @NotNull String name, Predicate<SitemapStorageInfo> storageInfoPredicate) throws IOException {
        ArrayList<String> arrayList;
        block10: {
            Collection<SitemapStorageInfo> storageInfo = this.getSitemaps(sitemapRoot, Collections.singleton(name));
            Iterator toDelete = storageInfo.stream().filter(storageInfoPredicate).iterator();
            if (!toDelete.hasNext()) {
                return Collections.emptyList();
            }
            ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);
            try {
                ArrayList<String> result = new ArrayList<String>(storageInfo.size());
                ArrayList<Event> events = new ArrayList<Event>(storageInfo.size());
                while (toDelete.hasNext()) {
                    String path = ((SitemapStorageInfo)toDelete.next()).getPath();
                    Resource resource = resolver.getResource(path);
                    if (resource == null) continue;
                    resolver.delete(resource);
                    result.add(path);
                    events.add(SitemapEventUtil.newPurgeEvent(path));
                }
                resolver.commit();
                events.forEach(arg_0 -> ((EventAdmin)this.eventAdmin).postEvent(arg_0));
                arrayList = result;
                if (resolver == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException | PersistenceException ex) {
                    throw new IOException("Failed to delete sitemaps: " + ex.getMessage(), ex);
                }
            }
            resolver.close();
        }
        return arrayList;
    }

    public Collection<SitemapStorageInfo> getSitemaps(Resource sitemapRoot) {
        return this.getSitemaps(sitemapRoot, Collections.emptySet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<SitemapStorageInfo> getSitemaps(Resource sitemapRoot, Collection<String> names) {
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Resource topLevelSitemapRoot = SitemapUtil.getTopLevelSitemapRoot(sitemapRoot);
            Predicate<SitemapStorageInfo> filter = !SitemapUtil.isTopLevelSitemapRoot(sitemapRoot) || !names.isEmpty() ? info -> names.stream().map(name -> SitemapUtil.getSitemapSelector(sitemapRoot, topLevelSitemapRoot, name)).anyMatch(selector -> info.getSitemapSelector().equals(selector) || info.getSitemapSelector().equals(selector + '-' + info.getFileIndex())) : any -> true;
            String storagePath = this.rootPath + topLevelSitemapRoot.getPath();
            Resource storageResource = resolver.getResource(storagePath);
            if (storageResource == null) {
                LOG.debug("Resource at {} does not exist.", (Object)storagePath);
                Set<SitemapStorageInfo> set = Collections.emptySet();
                return set;
            }
            Collection collection = StreamSupport.stream(storageResource.getChildren().spliterator(), false).filter(SitemapStorage::isValidSitemapFile).map(SitemapStorage::newSitemapStorageInfo).filter(filter).collect(Collectors.toList());
            return collection;
        }
        catch (LoginException ex) {
            LOG.warn("Could not list sitemaps from storage: {}", (Object)ex.getMessage());
            return Collections.emptySet();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copySitemap(Resource sitemapRoot, String sitemapSelector, OutputStream output) throws IOException {
        if (!SitemapUtil.isTopLevelSitemapRoot(sitemapRoot)) {
            return false;
        }
        String sitemapFilePath = this.rootPath + sitemapRoot.getPath() + '/' + sitemapSelector + XML_EXTENSION;
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            InputStream data = Optional.ofNullable(resolver.getResource(sitemapFilePath)).filter(r -> r.getName().endsWith(XML_EXTENSION)).filter(r -> r.isResourceType(RT_SITEMAP_FILE)).map(r -> (InputStream)r.getValueMap().get("jcr:data", InputStream.class)).orElse(null);
            if (data != null) {
                IOUtils.copyLarge((InputStream)data, (OutputStream)output);
                boolean bl2 = true;
                return bl2;
            }
            LOG.debug("Could not copy data from resource: {}", (Object)sitemapFilePath);
            boolean bl = false;
            return bl;
        }
        catch (LoginException ex) {
            LOG.warn("Could not copy sitemap to output: {}", (Object)ex.getMessage());
            return false;
        }
    }

    private boolean doesSitemapRootExist(Resource sitemapFile) {
        String path = sitemapFile.getPath();
        String parentPath = ResourceUtil.getParent((String)path);
        String sitemapRootPath = parentPath.substring(this.rootPath.length());
        Resource sitemapRoot = sitemapFile.getResourceResolver().getResource(sitemapRootPath);
        if (sitemapRoot == null || !SitemapUtil.isTopLevelSitemapRoot(sitemapRoot)) {
            LOG.debug("Sitemap file's top level sitemap root does not exist: {}", (Object)sitemapRootPath);
            return false;
        }
        String name = sitemapFile.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            LOG.debug("Unexpected name, missing extension: {}", (Object)name);
            return false;
        }
        Map<Resource, String> candidates = SitemapUtil.resolveSitemapRoots(sitemapRoot, name.substring(0, lastDot));
        return candidates.entrySet().stream().anyMatch(entry -> {
            Resource resource = (Resource)entry.getKey();
            Set<String> names = this.generatorManager.getNames(resource);
            Set<String> onDemandNames = this.generatorManager.getOnDemandNames(resource);
            return names.contains(entry.getValue()) && !onDemandNames.contains(entry.getValue());
        });
    }

    private boolean isExpired(@NotNull Resource state) {
        ValueMap stateProperties = state.getValueMap();
        Calendar lastModified = (Calendar)stateProperties.get("jcr:lastModified", Calendar.class);
        if (lastModified != null) {
            lastModified.add(14, this.maxStateAge);
            if (lastModified.after(Calendar.getInstance())) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("State at {} expired at {}", (Object)state.getPath(), (Object)lastModified.getTime().toGMTString());
            }
        }
        return true;
    }

    @NotNull
    private String getSitemapFilePath(@NotNull Resource sitemapRoot, @NotNull String name) {
        Resource topLevelSitemapRoot = SitemapUtil.getTopLevelSitemapRoot(sitemapRoot);
        return this.rootPath + topLevelSitemapRoot.getPath() + '/' + SitemapUtil.getSitemapSelector(sitemapRoot, topLevelSitemapRoot, name);
    }

    private static Resource getOrCreateFolder(@NotNull ResourceResolver resolver, @NotNull String path) throws PersistenceException {
        Resource folder = resolver.getResource(path);
        if (folder == null) {
            String parentPath = ResourceUtil.getParent((String)path);
            if (parentPath == null) {
                throw new PersistenceException("Cannot create parent path of " + path);
            }
            Resource parent = SitemapStorage.getOrCreateFolder(resolver, parentPath);
            folder = resolver.create(parent, ResourceUtil.getName((String)path), Collections.singletonMap("jcr:primaryType", "sling:Folder"));
        }
        return folder;
    }

    private static Stream<Resource> traverse(@Nullable Resource resource) {
        if (resource == null) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(resource), StreamSupport.stream(resource.getChildren().spliterator(), false).flatMap(SitemapStorage::traverse));
    }

    private static boolean isValidSitemapFile(Resource child) {
        ValueMap properties = child.getValueMap();
        return child.getName().endsWith(XML_EXTENSION) && child.isResourceType(RT_SITEMAP_FILE) && properties.get(PN_SITEMAP_NAME, String.class) != null && properties.get(PN_SITEMAP_FILE_INDEX, Integer.class) != null;
    }

    private static SitemapStorageInfo newSitemapStorageInfo(Resource child) {
        return new SitemapStorageInfo(child.getPath(), child.getName().substring(0, child.getName().lastIndexOf(46)), (String)child.getValueMap().get(PN_SITEMAP_NAME, String.class), (Integer)child.getValueMap().get(PN_SITEMAP_FILE_INDEX, Integer.class), (Calendar)child.getValueMap().get("jcr:lastModified", Calendar.class), (Integer)child.getValueMap().get(PN_SITEMAP_SIZE, (Object)0), (Integer)child.getValueMap().get(PN_SITEMAP_ENTRIES, (Object)0));
    }

    @ObjectClassDefinition(name="Apache Sling Sitemap - Storage")
    static @interface Configuration {
        @AttributeDefinition(name="Path", description="The path under which sitemap files generated in the background will be stored.")
        public String storagePath() default "/var/sitemaps";

        @AttributeDefinition(name="Max State Age", description="The number of milliseconds after which an intermediate state will deleted.")
        public int stateMaxAge() default 1800000;

        @AttributeDefinition(name="Cleanup Schedule", description="A cron expression defining the schedule at which stale intermediate states and old sitemaps will be removed.")
        public String scheduler_expression() default "0 0 1 * * ?";
    }
}

