/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Collection;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3Impl;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3ImplSelfReferencing;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@RunWith(value=MockitoJUnitRunner.class)
public class MockBundleContextStaticGreedySelfReferenceTest {
    private BundleContext bundleContext;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
    }

    @Test
    public void testSelfReferenceWithTargetFilter() throws InvalidSyntaxException {
        MockOsgi.registerInjectActivateService(ServiceInterface3Impl.class, (BundleContext)this.bundleContext);
        MockOsgi.registerInjectActivateService(ServiceInterface3ImplSelfReferencing.class, (BundleContext)this.bundleContext);
        Assert.assertNotNull((Object)this.getDefaultImplFromReference());
    }

    @Test
    public void testSelfReferenceWithTargetFilterReverse() throws InvalidSyntaxException {
        MockOsgi.registerInjectActivateService(ServiceInterface3ImplSelfReferencing.class, (BundleContext)this.bundleContext);
        MockOsgi.registerInjectActivateService(ServiceInterface3Impl.class, (BundleContext)this.bundleContext);
        Assert.assertNotNull((Object)this.getDefaultImplFromReference());
    }

    private ServiceInterface3 getDefaultImplFromReference() throws InvalidSyntaxException {
        Collection references = this.bundleContext.getServiceReferences(ServiceInterface3.class, "(!(prop1=abc))");
        ServiceInterface3 service = (ServiceInterface3)this.bundleContext.getService((ServiceReference)references.iterator().next());
        return ((ServiceInterface3ImplSelfReferencing)service).getDefaultImplementation();
    }
}

