/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.HashSet;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryChecker {
    private static final Logger log = LoggerFactory.getLogger(RepositoryChecker.class);
    private final PersistenceManager workspace;
    private final ChangeLog workspaceChanges;
    private final InternalVersionManager versionManager;

    public RepositoryChecker(PersistenceManager workspace, InternalVersionManager versionManager) {
        this.workspace = workspace;
        this.workspaceChanges = new ChangeLog();
        this.versionManager = versionManager;
    }

    public void check(NodeId id, boolean recurse) throws RepositoryException {
        try {
            log.debug("Checking consistency of node {}", (Object)id);
            NodeState state = this.workspace.load(id);
            this.checkVersionHistory(state);
            if (recurse) {
                for (ChildNodeEntry child : state.getChildNodeEntries()) {
                    if (RepositoryImpl.SYSTEM_ROOT_NODE_ID.equals(child.getId())) continue;
                    this.check(child.getId(), recurse);
                }
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to access node " + id, (Throwable)e);
        }
    }

    public void fix() throws RepositoryException {
        if (this.workspaceChanges.hasUpdates()) {
            log.warn("Fixing repository inconsistencies");
            try {
                this.workspace.store(this.workspaceChanges);
            }
            catch (ItemStateException e) {
                e.printStackTrace();
                throw new RepositoryException("Failed to fix workspace inconsistencies", (Throwable)e);
            }
        } else {
            log.info("No repository inconcistencies found");
        }
    }

    private void checkVersionHistory(NodeState node) {
        if (node.hasPropertyName(NameConstants.JCR_VERSIONHISTORY)) {
            log.debug("Checking version history of node {}", (Object)node.getNodeId());
            try {
                this.versionManager.getVersionHistoryOfNode(node.getNodeId());
            }
            catch (Exception e) {
                log.info("Removing references to a missing version history", (Throwable)e);
                this.removeVersionHistoryReferences(node);
            }
        }
    }

    private void removeVersionHistoryReferences(NodeState node) {
        NodeState modified = new NodeState(node, 2, true);
        HashSet<Name> mixins = new HashSet<Name>(node.getMixinTypeNames());
        if (mixins.remove(NameConstants.MIX_VERSIONABLE)) {
            modified.setMixinTypeNames(mixins);
        }
        this.removeProperty(modified, NameConstants.JCR_VERSIONHISTORY);
        this.removeProperty(modified, NameConstants.JCR_BASEVERSION);
        this.removeProperty(modified, NameConstants.JCR_PREDECESSORS);
        this.removeProperty(modified, NameConstants.JCR_ISCHECKEDOUT);
        this.workspaceChanges.modified(modified);
    }

    private void removeProperty(NodeState node, Name name) {
        if (node.hasPropertyName(name)) {
            node.removePropertyName(name);
            try {
                this.workspaceChanges.deleted(this.workspace.load(new PropertyId(node.getNodeId(), name)));
            }
            catch (ItemStateException itemStateException) {
                // empty catch block
            }
        }
    }
}

