/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;

public abstract class ClusterRecord {
    protected static final char END_MARKER = '\u0000';
    protected final Record record;
    protected String workspace;

    protected ClusterRecord(Record record, String workspace) {
        this.record = record;
        this.workspace = workspace;
    }

    protected ClusterRecord(Record record) {
        this(record, null);
    }

    public final void read() throws JournalException {
        this.doRead();
        this.readEndMarker();
    }

    protected abstract void doRead() throws JournalException;

    public final void write() throws JournalException {
        this.record.writeString(this.workspace);
        this.doWrite();
        this.record.writeChar('\u0000');
    }

    protected abstract void doWrite() throws JournalException;

    protected void readEndMarker() throws JournalException {
        char c = this.record.readChar();
        if (c != '\u0000') {
            String msg = "Expected end marker, found: " + c;
            throw new JournalException(msg);
        }
    }

    public abstract void process(ClusterRecordProcessor var1);

    public void update() throws JournalException {
        this.record.update();
    }

    public void cancelUpdate() {
        this.record.cancelUpdate();
    }

    public long getRevision() {
        return this.record.getRevision();
    }

    public String getWorkspace() {
        return this.workspace;
    }
}

