/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalField {
    public static String decimalToString(BigDecimal value) {
        switch (value.signum()) {
            case -1: {
                return "1" + DecimalField.invert(DecimalField.positiveDecimalToString(value.negate()), 1);
            }
            case 0: {
                return "2";
            }
        }
        return "3" + DecimalField.positiveDecimalToString(value);
    }

    public static BigDecimal stringToDecimal(String value) {
        long exp;
        long expSig;
        int sig = value.charAt(0) - 50;
        if (sig == 0) {
            return BigDecimal.ZERO;
        }
        if (sig < 0) {
            value = DecimalField.invert(value, 1);
        }
        if ((expSig = (long)(value.charAt(1) - 50)) == 0L) {
            exp = 0L;
            value = value.substring(2);
        } else {
            int expSize = value.charAt(2) - 48 + 1;
            if (expSig < 0L) {
                expSize = 11 - expSize;
            }
            String e = value.substring(3, 3 + expSize);
            exp = expSig * Long.parseLong(expSig < 0L ? DecimalField.invert(e, 0) : e);
            value = value.substring(3 + expSize);
        }
        BigInteger x = new BigInteger(value);
        int scale = (int)((long)value.length() - exp - 1L);
        return new BigDecimal(sig < 0 ? x.negate() : x, scale);
    }

    private static String positiveDecimalToString(BigDecimal value) {
        StringBuilder buff = new StringBuilder();
        long exp = value.precision() - value.scale() - 1;
        if (exp == 0L) {
            buff.append('2');
        } else {
            String e = String.valueOf(Math.abs(exp));
            e = String.valueOf(e.length() - 1) + e;
            if (exp > 0L) {
                buff.append('3').append(e);
            } else {
                buff.append('1').append(DecimalField.invert(e, 0));
            }
        }
        String s = value.unscaledValue().toString();
        int max = s.length() - 1;
        while (s.charAt(max) == '0') {
            --max;
        }
        return buff.append(s.substring(0, max + 1)).toString();
    }

    private static String invert(String s, int incLast) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(57 - chars[i] + 48);
        }
        int n = chars.length - 1;
        chars[n] = (char)(chars[n] + incLast);
        return String.valueOf(chars);
    }
}

