/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.commons.iterator.RowIterable;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.jackrabbit.core.query.lucene.join.ChildNodeJoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.DescendantNodeJoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.EquiJoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.JoinRow;
import org.apache.jackrabbit.core.query.lucene.join.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.SameNodeJoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.SimpleQueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JoinMerger {
    private final String type;
    protected final Set<String> leftSelectors;
    protected final Set<String> rightSelectors;
    private final String[] selectorNames;
    private final Map<String, PropertyValue> columns;
    private final String[] columnNames;
    protected final OperandEvaluator evaluator;
    protected final QueryObjectModelFactory factory;

    public static JoinMerger getJoinMerger(Join join, Map<String, PropertyValue> columns, OperandEvaluator evaluator, QueryObjectModelFactory factory) throws RepositoryException {
        JoinCondition condition = join.getJoinCondition();
        if (condition instanceof EquiJoinCondition) {
            return new EquiJoinMerger(join, columns, evaluator, factory, (EquiJoinCondition)condition);
        }
        if (condition instanceof SameNodeJoinCondition) {
            return new SameNodeJoinMerger(join, columns, evaluator, factory, (SameNodeJoinCondition)condition);
        }
        if (condition instanceof ChildNodeJoinCondition) {
            return new ChildNodeJoinMerger(join, columns, evaluator, factory, (ChildNodeJoinCondition)condition);
        }
        if (condition instanceof DescendantNodeJoinCondition) {
            return new DescendantNodeJoinMerger(join, columns, evaluator, factory, (DescendantNodeJoinCondition)condition);
        }
        throw new UnsupportedRepositoryOperationException("Unsupported join condition type: " + condition);
    }

    protected JoinMerger(Join join, Map<String, PropertyValue> columns, OperandEvaluator evaluator, QueryObjectModelFactory factory) throws RepositoryException {
        this.type = join.getJoinType();
        this.leftSelectors = this.getSelectorNames(join.getLeft());
        this.rightSelectors = this.getSelectorNames(join.getRight());
        LinkedHashSet<String> selectors = new LinkedHashSet<String>();
        selectors.addAll(this.leftSelectors);
        selectors.addAll(this.rightSelectors);
        this.selectorNames = selectors.toArray(new String[selectors.size()]);
        this.columns = columns;
        this.columnNames = columns.keySet().toArray(new String[columns.size()]);
        this.evaluator = evaluator;
        this.factory = factory;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getSelectorNames() {
        return this.selectorNames;
    }

    public Set<String> getLeftSelectors() {
        return this.leftSelectors;
    }

    public Set<String> getRightSelectors() {
        return this.rightSelectors;
    }

    private Set<String> getSelectorNames(Source source) throws RepositoryException {
        if (source instanceof Selector) {
            Selector selector = (Selector)source;
            return Collections.singleton(selector.getSelectorName());
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.addAll(this.getSelectorNames(join.getLeft()));
            set.addAll(this.getSelectorNames(join.getRight()));
            return set;
        }
        throw new UnsupportedRepositoryOperationException("Unknown source type: " + source);
    }

    public QueryResult merge(RowIterator leftRows, RowIterator rightRows, Set<Row> excludingOuterJoinRowsSet, Comparator<Row> rowComparator) throws RepositoryException {
        Map<String, List<Row>> map = this.buildRightRowValues(rightRows);
        if ("jcr.join.type.inner".equals(this.type) && !map.isEmpty()) {
            ArrayList<Row> rows = new ArrayList<Row>();
            for (Row leftRow : new RowIterable(leftRows)) {
                for (String value : this.getLeftValues(leftRow)) {
                    List<Row> matchingRows = map.get(value);
                    if (matchingRows == null) continue;
                    for (Row rightRow : matchingRows) {
                        rows.add(this.mergeRow(leftRow, rightRow));
                    }
                }
            }
            return this.asQueryResult(new RowIteratorAdapter(rows));
        }
        if ("jcr.join.type.left.outer".equals(this.type)) {
            if (map.isEmpty()) {
                if (excludingOuterJoinRowsSet == null) {
                    return this.asQueryResult(new RowIteratorAdapter((RangeIterator)leftRows){

                        public Object next() {
                            return JoinMerger.this.mergeRow((Row)super.next(), null);
                        }
                    });
                }
                return this.asQueryResult(new RowIteratorAdapter(Collections.emptySet()));
            }
            ArrayList<Row> rows = new ArrayList<Row>();
            for (Row leftRow : new RowIterable(leftRows)) {
                for (String value : this.getLeftValues(leftRow)) {
                    List<Row> matchingRows = map.get(value);
                    if (matchingRows != null) {
                        for (Row rightRow : matchingRows) {
                            if (excludingOuterJoinRowsSet == null) {
                                rows.add(this.mergeRow(leftRow, rightRow));
                                continue;
                            }
                            boolean isIncluded = false;
                            for (Row r : excludingOuterJoinRowsSet) {
                                if (rowComparator.compare(rightRow, r) != 0) continue;
                                isIncluded = true;
                                break;
                            }
                            if (!isIncluded) continue;
                            rows.add(this.mergeRow(leftRow, rightRow));
                        }
                        continue;
                    }
                    if (excludingOuterJoinRowsSet != null) continue;
                    rows.add(this.mergeRow(leftRow, null));
                }
            }
            return this.asQueryResult(new RowIteratorAdapter(rows));
        }
        return this.asQueryResult(new RowIteratorAdapter(Collections.emptySet()));
    }

    private QueryResult asQueryResult(RowIterator rowIterator) {
        return new SimpleQueryResult(this.columnNames, this.selectorNames, rowIterator);
    }

    private Map<String, List<Row>> buildRightRowValues(RowIterator rightRows) throws RepositoryException {
        HashMap<String, List<Row>> map = new HashMap<String, List<Row>>();
        for (Row row : new RowIterable(rightRows)) {
            for (String value : this.getRightValues(row)) {
                ArrayList<Row> rows = (ArrayList<Row>)map.get(value);
                if (rows == null) {
                    rows = new ArrayList<Row>();
                    map.put(value, rows);
                }
                rows.add(row);
            }
        }
        return map;
    }

    private Row mergeRow(Row left, Row right) {
        return new JoinRow(this.columns, this.evaluator, left, this.leftSelectors, right, this.rightSelectors);
    }

    public abstract Set<String> getLeftValues(Row var1) throws RepositoryException;

    public abstract Set<String> getRightValues(Row var1) throws RepositoryException;

    public abstract List<Constraint> getRightJoinConstraints(Collection<Row> var1) throws RepositoryException;
}

