/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.ProtectedItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLTemplate;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLEditor
extends ProtectedItemModifier
implements AccessControlEditor,
AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger(ACLEditor.class);
    private static final String DEFAULT_ACE_NAME = "ace";
    private final SessionImpl session;
    private final String acRootPath;

    ACLEditor(SessionImpl session, Path acRootPath) throws RepositoryException {
        super(64);
        this.session = session;
        this.acRootPath = session.getJCRPath(acRootPath);
    }

    ACLTemplate getACL(Principal principal) throws RepositoryException {
        AccessControlPolicy[] plcs;
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Unknown principal.");
        }
        String nPath = this.getPathToAcNode(principal);
        ACLTemplate acl = null;
        if (this.session.nodeExists(nPath) && (plcs = this.getPolicies(nPath)).length > 0) {
            acl = (ACLTemplate)plcs[0];
        }
        if (acl == null) {
            log.debug("No policy template for Principal " + principal.getName());
        }
        return acl;
    }

    public AccessControlPolicy[] getPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        this.checkProtectsNode(nodePath);
        NodeImpl acNode = this.getAcNode(nodePath);
        if (ACLEditor.isAccessControlled(acNode)) {
            return new AccessControlPolicy[]{this.createTemplate(acNode)};
        }
        return new AccessControlPolicy[0];
    }

    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws AccessControlException, RepositoryException {
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Cannot edit access control: " + principal.getName() + " isn't a known principal.");
        }
        ACLTemplate acl = this.getACL(principal);
        if (acl == null) {
            return new JackrabbitAccessControlPolicy[0];
        }
        return new JackrabbitAccessControlPolicy[]{acl};
    }

    public AccessControlPolicy[] editAccessControlPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        this.checkProtectsNode(nodePath);
        if (Text.isDescendant(this.acRootPath, nodePath)) {
            NodeImpl acNode = this.getAcNode(nodePath);
            if (acNode == null) {
                Principal p = this.getPrincipal(nodePath);
                if (p == null) {
                    throw new AccessControlException("Access control modification not allowed at " + nodePath);
                }
                acNode = this.createAcNode(nodePath);
            }
            if (!ACLEditor.isAccessControlled(acNode)) {
                return new AccessControlPolicy[]{this.createTemplate(acNode)};
            }
        }
        return new AccessControlPolicy[0];
    }

    public JackrabbitAccessControlPolicy[] editAccessControlPolicies(Principal principal) throws RepositoryException {
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Cannot edit access control: " + principal.getName() + " isn't a known principal.");
        }
        String nPath = this.getPathToAcNode(principal);
        NodeImpl acNode = !this.session.nodeExists(nPath) ? this.createAcNode(nPath) : (NodeImpl)this.session.getNode(nPath);
        if (!ACLEditor.isAccessControlled(acNode)) {
            return new JackrabbitAccessControlPolicy[]{this.createTemplate(acNode)};
        }
        return new JackrabbitAccessControlPolicy[0];
    }

    public void setPolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, PathNotFoundException, RepositoryException {
        AccessControlEntry[] aces;
        NodeImpl aclNode;
        this.checkProtectsNode(nodePath);
        this.checkValidPolicy(nodePath, policy);
        ACLTemplate acl = (ACLTemplate)policy;
        NodeImpl acNode = this.getAcNode(nodePath);
        if (acNode == null) {
            throw new PathNotFoundException("No such node " + nodePath);
        }
        if (acNode.hasNode(N_POLICY)) {
            aclNode = acNode.getNode(N_POLICY);
            NodeIterator aceNodes = aclNode.getNodes();
            while (aceNodes.hasNext()) {
                NodeImpl aceNode = (NodeImpl)aceNodes.nextNode();
                this.removeItem(aceNode);
            }
        } else {
            aclNode = this.addNode(acNode, N_POLICY, NT_REP_ACL);
        }
        for (AccessControlEntry ace1 : aces = acl.getAccessControlEntries()) {
            AccessControlEntryImpl ace = (AccessControlEntryImpl)ace1;
            Name nodeName = ACLEditor.getUniqueNodeName(aclNode, "entry");
            Name ntName = ace.isAllow() ? NT_REP_GRANT_ACE : NT_REP_DENY_ACE;
            NodeImpl aceNode = this.addNode(aclNode, nodeName, ntName);
            ValueFactory vf = this.session.getValueFactory();
            this.setProperty(aceNode, P_PRINCIPAL_NAME, vf.createValue(ace.getPrincipal().getName()));
            Privilege[] privs = ace.getPrivileges();
            Value[] vs = new Value[privs.length];
            for (int j = 0; j < privs.length; ++j) {
                vs[j] = vf.createValue(privs[j].getName(), 7);
            }
            this.setProperty(aceNode, P_PRIVILEGES, vs);
            Set<Name> restrNames = ace.getRestrictions().keySet();
            for (Name restrName : restrNames) {
                Value value = ace.getRestriction(restrName);
                this.setProperty(aceNode, restrName, value);
            }
        }
        this.markModified((NodeImpl)aclNode.getParent());
    }

    public void removePolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, PathNotFoundException, RepositoryException {
        JackrabbitAccessControlPolicy tmpl;
        this.checkProtectsNode(nodePath);
        this.checkValidPolicy(nodePath, policy);
        NodeImpl acNode = this.getAcNode(nodePath);
        if (ACLEditor.isAccessControlled(acNode) && (tmpl = this.createTemplate(acNode)).equals(policy)) {
            this.removeItem(acNode.getNode(N_POLICY));
            return;
        }
        throw new AccessControlException("Policy " + policy + " does not apply to " + nodePath);
    }

    private NodeImpl getAcNode(String nodePath) throws PathNotFoundException, RepositoryException {
        if (Text.isDescendant(this.acRootPath, nodePath)) {
            return (NodeImpl)this.session.getNode(nodePath);
        }
        return null;
    }

    private NodeImpl createAcNode(String acPath) throws RepositoryException {
        String[] segms = Text.explode(acPath, 47, false);
        StringBuilder currentPath = new StringBuilder();
        NodeImpl node = (NodeImpl)this.session.getRootNode();
        for (int i = 0; i < segms.length; ++i) {
            Name ntName;
            if (i > 0) {
                currentPath.append('/').append(segms[i]);
            }
            Name nName = this.session.getQName(segms[i]);
            if (this.denotesPrincipalPath(currentPath.toString())) {
                ntName = NT_REP_PRINCIPAL_ACCESS_CONTROL;
            } else {
                Name name = ntName = i < segms.length - 1 ? NT_REP_ACCESS_CONTROL : NT_REP_PRINCIPAL_ACCESS_CONTROL;
            }
            if (node.hasNode(nName)) {
                NodeImpl n = node.getNode(nName);
                if (!n.isNodeType(ntName)) {
                    throw new RepositoryException("Error while creating access control node: Expected nodetype " + this.session.getJCRName(ntName) + " below /rep:accessControl, was " + node.getPrimaryNodeType().getName() + " instead");
                }
                node = n;
                continue;
            }
            node = this.addNode(node, nName, ntName);
        }
        return node;
    }

    private boolean denotesPrincipalPath(final String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        ItemBasedPrincipal princ = new ItemBasedPrincipal(){

            public String getPath() throws RepositoryException {
                return path;
            }

            public String getName() {
                return Text.getName(path);
            }
        };
        try {
            return this.session.getUserManager().getAuthorizable(princ) != null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private void checkProtectsNode(String nodePath) throws RepositoryException {
        NodeImpl n;
        if (this.session.nodeExists(nodePath) && ((n = (NodeImpl)this.session.getNode(nodePath)).isNodeType(NT_REP_ACL) || n.isNodeType(NT_REP_ACE))) {
            throw new AccessControlException("Node " + nodePath + " defines ACL or ACE.");
        }
    }

    private void checkValidPolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException {
        if (policy == null || !(policy instanceof ACLTemplate)) {
            throw new AccessControlException("Attempt to set/remove invalid policy " + policy);
        }
        ACLTemplate acl = (ACLTemplate)policy;
        if (!nodePath.equals(acl.getPath())) {
            throw new AccessControlException("Policy " + policy + " is not applicable or does not apply to the node at " + nodePath);
        }
    }

    String getPathToAcNode(Principal principal) throws RepositoryException {
        StringBuffer princPath = new StringBuffer(this.acRootPath);
        if (principal instanceof ItemBasedPrincipal) {
            princPath.append(((ItemBasedPrincipal)principal).getPath());
        } else {
            princPath.append("/");
            princPath.append(Text.escapeIllegalJcrChars(principal.getName()));
        }
        return princPath.toString();
    }

    private Principal getPrincipal(String pathToACNode) throws RepositoryException {
        String id = ACLEditor.getPathName(pathToACNode);
        UserManager uMgr = this.session.getUserManager();
        Authorizable authorizable = uMgr.getAuthorizable(id);
        if (authorizable == null && pathToACNode.startsWith(this.acRootPath)) {
            final String principalPath = pathToACNode.substring(this.acRootPath.length());
            if (principalPath.indexOf(47, 1) > 0) {
                authorizable = uMgr.getAuthorizable(new ItemBasedPrincipal(){

                    public String getPath() throws RepositoryException {
                        return principalPath;
                    }

                    public String getName() {
                        return Text.getName(principalPath);
                    }
                });
            } else {
                return this.session.getPrincipalManager().getPrincipal(Text.getName(principalPath));
            }
        }
        return authorizable == null ? null : authorizable.getPrincipal();
    }

    private static String getPathName(String pathToACNode) {
        return Text.unescapeIllegalJcrChars(Text.getName(pathToACNode));
    }

    private static boolean isAccessControlled(NodeImpl node) throws RepositoryException {
        return node != null && node.isNodeType(NT_REP_PRINCIPAL_ACCESS_CONTROL) && node.hasNode(N_POLICY);
    }

    private JackrabbitAccessControlPolicy createTemplate(NodeImpl acNode) throws RepositoryException {
        if (!acNode.isNodeType(NT_REP_PRINCIPAL_ACCESS_CONTROL)) {
            String msg = "Unable to edit Access Control at " + acNode.getPath() + ". Expected node of type rep:PrinicipalAccessControl, was " + acNode.getPrimaryNodeType().getName();
            log.debug(msg);
            throw new AccessControlException(msg);
        }
        Principal principal = this.getPrincipal(acNode.getPath());
        if (principal == null) {
            String principalName = ACLEditor.getPathName(acNode.getPath());
            log.warn("Principal with name " + principalName + " unknown to PrincipalManager.");
            principal = new PrincipalImpl(principalName);
        }
        return new ACLTemplate(principal, acNode);
    }

    protected static Name getUniqueNodeName(Node node, String name) throws RepositoryException {
        if (name == null) {
            name = DEFAULT_ACE_NAME;
        } else {
            try {
                NameParser.checkFormat(name);
            }
            catch (NameException e) {
                name = DEFAULT_ACE_NAME;
                log.debug("Invalid path name for Permission: " + name + ".");
            }
        }
        int i = 0;
        String check = name;
        while (node.hasNode(check)) {
            check = name + i;
            ++i;
        }
        return ((SessionImpl)node.getSession()).getQName(check);
    }
}

