/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.lock;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;

public abstract class LockOperation<T>
extends SessionOperation<T> {
    protected final SessionDelegate session;
    private final String path;

    protected LockOperation(SessionContext context, String absPath, String name) throws PathNotFoundException {
        super(name);
        this.session = context.getSessionDelegate();
        this.path = context.getOakPathOrThrowNotFound(absPath);
    }

    @Override
    public boolean isRefresh() {
        return true;
    }

    @Override
    @NotNull
    public T perform() throws RepositoryException {
        this.session.refresh(true);
        NodeDelegate node = this.session.getNode(this.path);
        if (node != null) {
            return this.perform(node);
        }
        throw new PathNotFoundException("Node " + this.path + " not found");
    }

    @Override
    public void performVoid() throws RepositoryException {
        this.session.refresh(true);
        NodeDelegate node = this.session.getNode(this.path);
        if (node == null) {
            throw new PathNotFoundException("Node " + this.path + " not found");
        }
        this.performVoid(node);
    }

    @NotNull
    protected T perform(@NotNull NodeDelegate node) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    protected void performVoid(@NotNull NodeDelegate node) throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

