/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.math.BigDecimal;
import java.util.List;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Function;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.Iterables;
import sling-mock-oak.com.google.common.collect.Lists;

abstract class MultiPropertyState<T>
extends EmptyPropertyState {
    protected final List<T> values;

    protected MultiPropertyState(String name, Iterable<T> values) {
        super(name);
        this.values = Lists.newArrayList(values);
    }

    public abstract Conversions.Converter getConverter(T var1);

    private <S> S convertTo(Type<S> type) {
        switch (type.tag()) {
            case 1: {
                return (S)Iterables.transform(this.values, new Function<T, String>(){

                    @Override
                    public String apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toString();
                    }
                });
            }
            case 2: {
                return (S)Iterables.transform(this.values, new Function<T, Blob>(){

                    @Override
                    public Blob apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toBinary();
                    }
                });
            }
            case 3: {
                return (S)Iterables.transform(this.values, new Function<T, Long>(){

                    @Override
                    public Long apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toLong();
                    }
                });
            }
            case 4: {
                return (S)Iterables.transform(this.values, new Function<T, Double>(){

                    @Override
                    public Double apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toDouble();
                    }
                });
            }
            case 5: {
                return (S)Iterables.transform(this.values, new Function<T, String>(){

                    @Override
                    public String apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toDate();
                    }
                });
            }
            case 6: {
                return (S)Iterables.transform(this.values, new Function<T, Boolean>(){

                    @Override
                    public Boolean apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toBoolean();
                    }
                });
            }
            case 7: {
                return (S)Iterables.transform(this.values, new Function<T, String>(){

                    @Override
                    public String apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toString();
                    }
                });
            }
            case 8: {
                return (S)Iterables.transform(this.values, new Function<T, String>(){

                    @Override
                    public String apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toString();
                    }
                });
            }
            case 9: {
                return (S)Iterables.transform(this.values, new Function<T, String>(){

                    @Override
                    public String apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toString();
                    }
                });
            }
            case 10: {
                return (S)Iterables.transform(this.values, new Function<T, String>(){

                    @Override
                    public String apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toString();
                    }
                });
            }
            case 11: {
                return (S)Iterables.transform(this.values, new Function<T, String>(){

                    @Override
                    public String apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toString();
                    }
                });
            }
            case 12: {
                return (S)Iterables.transform(this.values, new Function<T, BigDecimal>(){

                    @Override
                    public BigDecimal apply(T value) {
                        return MultiPropertyState.this.getConverter(value).toDecimal();
                    }
                });
            }
        }
        throw new IllegalArgumentException("Unknown type:" + type);
    }

    @NotNull
    public <S> S getValue(Type<S> type) {
        Preconditions.checkState(type.isArray(), "Type must be an array type");
        if (this.getType() == type) {
            return (S)this.values;
        }
        return this.convertTo(type);
    }

    private <S> S convertTo(Type<S> type, int index) {
        switch (type.tag()) {
            case 1: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 2: {
                return (S)this.getConverter(this.values.get(index)).toBinary();
            }
            case 3: {
                return (S)Long.valueOf(this.getConverter(this.values.get(index)).toLong());
            }
            case 4: {
                return (S)Double.valueOf(this.getConverter(this.values.get(index)).toDouble());
            }
            case 5: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 6: {
                return (S)Boolean.valueOf(this.getConverter(this.values.get(index)).toBoolean());
            }
            case 7: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 8: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 9: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 10: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 11: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 12: {
                return (S)this.getConverter(this.values.get(index)).toDecimal();
            }
        }
        throw new IllegalArgumentException("Unknown type:" + type);
    }

    @NotNull
    public <S> S getValue(Type<S> type, int index) {
        Preconditions.checkArgument(!type.isArray(), "Type must not be an array type");
        if (this.getType().getBaseType() == type) {
            return (S)this.values.get(index);
        }
        return this.convertTo(type, index);
    }

    @Override
    public final int count() {
        return this.values.size();
    }

    @Override
    public long size(int index) {
        return this.convertTo(Type.STRING, index).length();
    }
}

