/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.xpath;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.query.QueryOptions;
import org.apache.jackrabbit.oak.query.xpath.Expression;
import org.apache.jackrabbit.oak.query.xpath.Order;
import org.apache.jackrabbit.oak.query.xpath.Selector;
import org.apache.jackrabbit.oak.query.xpath.XPathToSQL2Converter;

public class Statement {
    private static final UnsupportedOperationException TOO_MANY_UNION = new UnsupportedOperationException("Too many union queries");
    private static final int MAX_UNION = Integer.getInteger("oak.xpathMaxUnion", 1000);
    private static final boolean KEEP_UNION_ORDER = Boolean.getBoolean("oak.xpath.keepUnionOrder");
    boolean explain;
    boolean measure;
    private Selector columnSelector;
    private ArrayList<Expression> columnList = new ArrayList();
    private ArrayList<Selector> selectors;
    private Expression where;
    ArrayList<Order> orderList = new ArrayList();
    String xpathQuery;
    QueryOptions queryOptions;

    public Statement optimize() {
        Statement.ignoreOrderByScoreDesc(this.orderList);
        if (this.where == null) {
            return this;
        }
        this.where = this.where.optimize();
        this.optimizeSelectorNodeTypes();
        ArrayList<Expression> unionList = new ArrayList<Expression>();
        try {
            Statement.addToUnionList(this.where, unionList);
        }
        catch (UnsupportedOperationException e) {
            return this;
        }
        if (unionList.size() == 1) {
            return this;
        }
        Statement union = null;
        for (int i = 0; i < unionList.size(); ++i) {
            Expression e = unionList.get(i);
            Statement s = new Statement();
            s.columnSelector = new Selector(this.columnSelector);
            s.selectors = this.cloneSelectors();
            s.columnList = this.columnList;
            s.where = e;
            union = union == null ? s : new UnionStatement(union.optimize(), s.optimize());
        }
        union.orderList = this.orderList;
        union.xpathQuery = this.xpathQuery;
        union.measure = this.measure;
        union.explain = this.explain;
        union.queryOptions = this.queryOptions;
        return union;
    }

    private ArrayList<Selector> cloneSelectors() {
        ArrayList<Selector> list = new ArrayList<Selector>();
        for (Selector s : this.selectors) {
            list.add(new Selector(s));
        }
        return list;
    }

    private void optimizeSelectorNodeTypes() {
        if (!XPathToSQL2Converter.NODETYPE_OPTIMIZATION) {
            return;
        }
        for (int i = 0; i < this.selectors.size(); ++i) {
            String selectorName;
            String nodeType;
            Selector s = this.selectors.get(i);
            if (s.nodeType != null && !"nt:base".equals(s.nodeType) || (nodeType = this.where.getMostSpecificNodeType(selectorName = this.selectors.size() == 1 ? null : s.name)) == null) continue;
            s.nodeType = nodeType;
        }
    }

    private static void addToUnionList(Expression condition, ArrayList<Expression> unionList) {
        if (condition instanceof Expression.OrCondition) {
            Expression.OrCondition or = (Expression.OrCondition)condition;
            Statement.addToUnionList(or.left, unionList);
            Statement.addToUnionList(or.right, unionList);
            return;
        }
        if (condition instanceof Expression.AndCondition) {
            Expression.AndCondition and = (Expression.AndCondition)condition;
            and = and.pullOrRight();
            if (and.right instanceof Expression.OrCondition) {
                Expression.OrCondition or = (Expression.OrCondition)and.right;
                Statement.addToUnionList(new Expression.AndCondition(and.left, or.left), unionList);
                Statement.addToUnionList(new Expression.AndCondition(and.left, or.right), unionList);
                return;
            }
        }
        if (unionList.size() > MAX_UNION) {
            throw TOO_MANY_UNION;
        }
        unionList.add(condition);
    }

    public String toString() {
        int i;
        StringBuilder buff = new StringBuilder();
        if (this.explain) {
            buff.append("explain ");
        }
        if (this.measure) {
            buff.append("measure ");
        }
        buff.append("select ");
        buff.append(new Expression.Property(this.columnSelector, "jcr:path", false).toString());
        if (this.selectors.size() > 1) {
            buff.append(" as ").append('[').append("jcr:path").append(']');
        }
        buff.append(", ");
        buff.append(new Expression.Property(this.columnSelector, "jcr:score", false).toString());
        if (this.selectors.size() > 1) {
            buff.append(" as ").append('[').append("jcr:score").append(']');
        }
        if (this.columnList.isEmpty()) {
            buff.append(", ");
            buff.append(new Expression.Property(this.columnSelector, "*", false).toString());
        } else {
            for (i = 0; i < this.columnList.size(); ++i) {
                buff.append(", ");
                Expression e = this.columnList.get(i);
                String columnName = e.toString();
                buff.append(columnName);
                if (this.selectors.size() <= 1) continue;
                buff.append(" as [").append(e.getColumnAliasName()).append("]");
            }
        }
        buff.append(" from ");
        for (i = 0; i < this.selectors.size(); ++i) {
            String nodeType;
            Selector s = this.selectors.get(i);
            if (i > 0) {
                buff.append(" inner join ");
            }
            if ((nodeType = s.nodeType) == null) {
                nodeType = "nt:base";
            }
            buff.append('[' + nodeType + ']').append(" as ").append(s.name);
            if (s.joinCondition == null) continue;
            buff.append(" on ").append(s.joinCondition);
        }
        if (this.where != null) {
            buff.append(" where ").append(this.where.toString());
        }
        if (!this.orderList.isEmpty()) {
            buff.append(" order by ");
            for (i = 0; i < this.orderList.size(); ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.orderList.get(i));
            }
        }
        Statement.appendQueryOptions(buff, this.queryOptions);
        Statement.appendXPathAsComment(buff, this.xpathQuery);
        return buff.toString();
    }

    private static void ignoreOrderByScoreDesc(ArrayList<Order> orderList) {
        if (orderList.size() != 1) {
            return;
        }
        Order order = orderList.get(0);
        if (!order.descending) {
            return;
        }
        if (!order.expr.toString().equals("[jcr:score]")) {
            return;
        }
        orderList.remove(0);
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public void setMeasure(boolean measure) {
        this.measure = measure;
    }

    public void addSelectColumn(Expression.Property p) {
        this.columnList.add(p);
    }

    public void setSelectors(ArrayList<Selector> selectors) {
        this.selectors = selectors;
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public void addOrderBy(Order order) {
        this.orderList.add(order);
    }

    public void setColumnSelector(Selector columnSelector) {
        this.columnSelector = columnSelector;
    }

    public void setOriginalQuery(String xpathQuery) {
        this.xpathQuery = xpathQuery;
    }

    private static void appendQueryOptions(StringBuilder buff, QueryOptions queryOptions) {
        if (queryOptions == null) {
            return;
        }
        buff.append(" option(");
        int optionCount = 0;
        if (queryOptions.traversal != QueryOptions.Traversal.DEFAULT) {
            buff.append("traversal " + (Object)((Object)queryOptions.traversal));
            ++optionCount;
        }
        if (queryOptions.indexName != null) {
            if (optionCount > 0) {
                buff.append(", ");
            }
            buff.append("index name [");
            buff.append(queryOptions.indexName);
            buff.append("]");
            ++optionCount;
        }
        if (queryOptions.indexTag != null) {
            if (optionCount > 0) {
                buff.append(", ");
            }
            buff.append("index tag [");
            buff.append(queryOptions.indexTag);
            buff.append("]");
            ++optionCount;
        }
        buff.append(")");
    }

    private static void appendXPathAsComment(StringBuilder buff, String xpath) {
        if (xpath == null) {
            return;
        }
        buff.append(" /* xpath: ");
        String xpathEscaped = xpath.replaceAll("\\*\\/", "* /");
        buff.append(xpathEscaped);
        buff.append(" */");
    }

    public void setQueryOptions(QueryOptions options) {
        this.queryOptions = options;
    }

    static class UnionStatement
    extends Statement {
        private final Statement s1;
        private final Statement s2;

        UnionStatement(Statement s1, Statement s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        @Override
        public Statement optimize() {
            if (!KEEP_UNION_ORDER) {
                Statement.ignoreOrderByScoreDesc(this.orderList);
            }
            Statement s1b = this.s1.optimize();
            Statement s2b = this.s2.optimize();
            if (this.s1 == s1b && this.s2 == s2b) {
                return this;
            }
            UnionStatement union = new UnionStatement(s1b, s2b);
            union.explain = this.explain;
            union.measure = this.measure;
            union.orderList = this.orderList;
            union.queryOptions = this.queryOptions;
            union.xpathQuery = this.xpathQuery;
            return union;
        }

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            if (this.explain) {
                buff.append("explain ");
            }
            if (this.measure) {
                buff.append("measure ");
            }
            buff.append(this.s1).append(" union ").append(this.s2);
            if (this.orderList != null && !this.orderList.isEmpty()) {
                buff.append(" order by ");
                for (int i = 0; i < this.orderList.size(); ++i) {
                    if (i > 0) {
                        buff.append(", ");
                    }
                    buff.append(this.orderList.get(i));
                }
            }
            Statement.appendQueryOptions(buff, this.queryOptions);
            Statement.appendXPathAsComment(buff, this.xpathQuery);
            return buff.toString();
        }
    }
}

