/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Arrays;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.MockSlingScriptHelper;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.BundleContext;

public class MockSlingScriptHelperTest {
    private ResourceResolver resourceResolver;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private MockSlingJakartaHttpServletRequest jakartaRequest;
    private MockSlingJakartaHttpServletResponse jakartaResponse;
    private BundleContext bundleContext;
    private SlingScriptHelper scriptHelper;

    @Before
    public void setUp() throws Exception {
        this.bundleContext = MockOsgi.newBundleContext();
        this.resourceResolver = MockSling.newResourceResolver((BundleContext)this.bundleContext);
        this.jakartaRequest = new MockSlingJakartaHttpServletRequest(this.resourceResolver, this.bundleContext);
        this.request = new MockSlingHttpServletRequest(this.jakartaRequest);
        this.jakartaResponse = new MockSlingJakartaHttpServletResponse();
        this.response = new MockSlingHttpServletResponse(this.jakartaResponse);
        this.scriptHelper = MockSling.newSlingScriptHelper((SlingHttpServletRequest)this.request, (SlingHttpServletResponse)this.response, (BundleContext)this.bundleContext);
    }

    @After
    public void tearDown() {
        this.resourceResolver.close();
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Deprecated(since="4.0.0")
    @Test
    public void testRequest() {
        Assert.assertSame((Object)this.request, (Object)this.scriptHelper.getRequest());
    }

    @Deprecated(since="4.0.0")
    @Test
    public void testResponse() {
        Assert.assertSame((Object)this.response, (Object)this.scriptHelper.getResponse());
    }

    @Test
    public void testJakartaRequest() {
        Assert.assertSame((Object)this.jakartaRequest, (Object)this.scriptHelper.getJakartaRequest());
    }

    @Test
    public void testJakartaResponse() {
        Assert.assertSame((Object)this.jakartaResponse, (Object)this.scriptHelper.getJakartaResponse());
    }

    @Test
    public void testGetService() {
        this.bundleContext.registerService(String.class.getName(), (Object)"test", null);
        Assert.assertEquals((Object)"test", (Object)this.scriptHelper.getService(String.class));
    }

    @Test
    public void testGetServices() {
        Object[] services;
        for (Integer n : services = new Integer[]{1, 2, 3}) {
            this.bundleContext.registerService(Integer.class.getName(), (Object)n, null);
        }
        Object[] servicesResult = (Integer[])this.scriptHelper.getServices(Integer.class, null);
        Arrays.sort(servicesResult);
        Assert.assertArrayEquals((Object[])services, (Object[])servicesResult);
    }

    @Deprecated(since="4.0.0")
    @Test
    public void testNewSlingScriptHelperForNotMockSlingRequest() {
        SlingHttpServletRequest mockRequest = (SlingHttpServletRequest)Mockito.mock(SlingHttpServletRequest.class);
        SlingHttpServletResponse mockResponse = (SlingHttpServletResponse)Mockito.mock(SlingHttpServletResponse.class);
        SlingScriptHelper slingScriptHelper = MockSling.newSlingScriptHelper((SlingHttpServletRequest)mockRequest, (SlingHttpServletResponse)mockResponse, (BundleContext)this.bundleContext);
        Assert.assertTrue((boolean)(slingScriptHelper.getJakartaRequest() instanceof JavaxToJakartaRequestWrapper));
        Assert.assertTrue((boolean)(slingScriptHelper.getJakartaResponse() instanceof JavaxToJakartaResponseWrapper));
    }

    @Test
    public void testGetScript() {
        Assert.assertNull((Object)this.scriptHelper.getScript());
        SlingScript mockSlingScript = (SlingScript)Mockito.mock(SlingScript.class);
        ((MockSlingScriptHelper)this.scriptHelper).setScript(mockSlingScript);
        Assert.assertSame((Object)mockSlingScript, (Object)this.scriptHelper.getScript());
    }

    @Test
    public void testSetScript() {
        SlingScript mockSlingScript = (SlingScript)Mockito.mock(SlingScript.class);
        ((MockSlingScriptHelper)this.scriptHelper).setScript(mockSlingScript);
        Assert.assertSame((Object)mockSlingScript, (Object)this.scriptHelper.getScript());
    }

    @Deprecated
    @Test
    public void testDispose() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.dispose());
    }

    @Test
    public void testForwardStringRequestDispatcherOptions() {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.forward("/path", options));
    }

    @Test
    public void testForwardStringString() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.forward("/path", ""));
    }

    @Test
    public void testForwardString() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.forward("/path"));
    }

    @Test
    public void testForwardResource() {
        Resource resource = this.resourceResolver.resolve("/path");
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.forward(resource));
    }

    @Test
    public void testForwardResourceString() {
        Resource resource = this.resourceResolver.resolve("/path");
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.forward(resource, ""));
    }

    @Test
    public void testForwardResourceRequestDispatcherOptions() {
        Resource resource = this.resourceResolver.resolve("/path");
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.forward(resource, options));
    }

    @Test
    public void testIncludeStringRequestDispatcherOptions() {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.include("/path", options));
    }

    @Test
    public void testIncludeStringString() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.include("/path", ""));
    }

    @Test
    public void testIncludeString() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.include("/path"));
    }

    @Test
    public void testIncludeResource() {
        Resource resource = this.resourceResolver.resolve("/path");
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.include(resource));
    }

    @Test
    public void testIncludeResourceString() {
        Resource resource = this.resourceResolver.resolve("/path");
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.include(resource, ""));
    }

    @Test
    public void testIncludeResourceRequestDispatcherOptions() {
        Resource resource = this.resourceResolver.resolve("/path");
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.scriptHelper.include(resource, options));
    }
}

