/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.http;

import java.util.ArrayList;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.tools.http.Request;

public class RequestBuilder {
    private final String baseUrl;

    public RequestBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Request buildGetRequest(String path, String ... queryParameters) {
        return new Request((HttpUriRequest)new HttpGet(this.buildUrl(path, queryParameters)));
    }

    public Request buildPostRequest(String path) {
        return new Request((HttpUriRequest)new HttpPost(this.buildUrl(path, new String[0])));
    }

    public Request buildOtherRequest(HttpRequestBase r) {
        return new Request((HttpUriRequest)r);
    }

    public String buildUrl(String path, String ... queryParameters) {
        StringBuilder sb = new StringBuilder();
        if (queryParameters == null || queryParameters.length == 0) {
            sb.append(this.baseUrl);
            sb.append(path);
        } else {
            if (queryParameters.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid number of queryParameters arguments (" + queryParameters.length + "), must be even");
            }
            ArrayList<BasicNameValuePair> p = new ArrayList<BasicNameValuePair>();
            for (int i = 0; i < queryParameters.length; i += 2) {
                p.add(new BasicNameValuePair(queryParameters[i], queryParameters[i + 1]));
            }
            sb.append(this.baseUrl);
            sb.append(path);
            sb.append("?");
            sb.append(URLEncodedUtils.format(p, (String)"UTF-8"));
        }
        return sb.toString();
    }
}

