/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.filters.Flip;
import net.coobird.thumbnailator.filters.ImageFilter;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, immediate=true)
public class FlipHandler
implements TransformationHandler {
    public static final String RESOURCE_TYPE = "sling/thumbnails/transformers/flip";
    public static final String PN_DIRECTION = "direction";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public void handle(InputStream inputStream, OutputStream outputStream, TransformationHandlerConfig config) throws IOException {
        String direction = ((String)config.getProperties().get(PN_DIRECTION, (Object)"")).toUpperCase();
        ImageFilter flipper = null;
        if ("HORIZONTAL".equals(direction)) {
            flipper = Flip.HORIZONTAL;
        } else if ("VERTICAL".equals(direction)) {
            flipper = Flip.VERTICAL;
        } else {
            throw new BadRequestException("Could not flip image with configuration: \n%s", config.getProperties());
        }
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        builder.addFilter(flipper);
        builder.scale(1.0);
        builder.toOutputStream(outputStream);
    }
}

