/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Apache Sling Log Tracer", description="Provides support for enabling log for specific loggers on per request basis. Refer to http://sling.apache.org/documentation/bundles/log-tracers.html for more details")
public @interface Configuration {
    @AttributeDefinition(name="Tracer Sets", description="Default list of tracer sets configured. Tracer Set config confirms to following format. <set name> : <logger name>;level=<level name>, other loggers")
    public String[] tracerSets() default {"oak-query : org.apache.jackrabbit.oak.query.QueryEngineImpl;level=debug", "oak-writes : org.apache.jackrabbit.oak.jcr.operations.writes;level=trace"};

    @AttributeDefinition(name="Enabled", description="Enable the Tracer")
    public boolean enabled();

    @AttributeDefinition(name="Recording Servlet Enabled", description="Enable the Tracer Servlet. This servlet is required for the tracer recording feature to work and provides access to the json dump of the recording performed")
    public boolean servletEnabled();

    @AttributeDefinition(name="Recording Cache Size", description="Recording cache size in MB which would be used to temporary cache the recording data")
    public int recordingCacheSizeInMB() default 50;

    @AttributeDefinition(name="Recording Cache Duration", description="Time in seconds upto which the recording data would be held in memory before expiry")
    public long recordingCacheDurationInSecs() default 900L;

    @AttributeDefinition(name="Compress Recording", description="Enable compression for recoding held in memory")
    public boolean recordingCompressionEnabled() default true;

    @AttributeDefinition(name="GZip Response", description="If enabled the response sent would be compressed")
    public boolean gzipResponse() default true;
}

