/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.testservices.internal;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.post.AbstractPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.ValidationService;
import org.apache.sling.validation.model.ValidationModel;
import org.apache.sling.validation.testservices.internal.ValidationPostResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PostOperation.class}, property={"sling.post.operation=validation"})
public class ValidationPostOperation
extends AbstractPostOperation {
    private final Logger logger = LoggerFactory.getLogger(ValidationPostOperation.class);
    @Reference
    private ValidationService validationService;

    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) {
        if (response instanceof ValidationPostResponse) {
            LinkedHashMap base = new LinkedHashMap();
            ValueMapDecorator valueMap = new ValueMapDecorator(base);
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                valueMap.put(name, (Object)request.getRequestParameter(name).getString());
            }
            String resourceType = request.getRequestParameter("sling:resourceType").getString();
            if (resourceType != null && !"".equals(resourceType)) {
                String resourcePath = request.getRequestPathInfo().getResourcePath();
                ValidationModel validationModel = this.validationService.getValidationModel(resourceType, resourcePath, false);
                if (validationModel != null) {
                    ValidationResult validationResult = this.validationService.validate((ValueMap)valueMap, validationModel);
                    ValidationPostResponse validationPostResponse = (ValidationPostResponse)response;
                    validationPostResponse.setValidationResult(validationResult);
                } else {
                    this.logger.error("No validation model for resourceType {} and resourcePath {} ", (Object)resourceType, (Object)resourcePath);
                }
            } else {
                this.logger.error("resource type is empty");
            }
        }
    }
}

