/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.testservices.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationPostResponse
extends AbstractPostResponse {
    private ValidationResult validationResult;
    private final ResourceBundle resourceBundle;
    private static final Logger LOG = LoggerFactory.getLogger(ValidationPostResponse.class);

    public ValidationPostResponse(@Nonnull ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    protected void doSend(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        PrintWriter printWriter = response.getWriter();
        JSONWriter writer = new JSONWriter(printWriter);
        writer.object();
        boolean validationError = false;
        if (this.validationResult != null) {
            try {
                writer.key("valid").value(this.validationResult.isValid());
                writer.key("failures").array();
                for (ValidationFailure failure : this.validationResult.getFailures()) {
                    writer.object();
                    writer.key("message").value(failure.getMessage(this.resourceBundle));
                    writer.key("location").value(failure.getLocation());
                    writer.key("severity").value(failure.getSeverity());
                    writer.endObject();
                }
                writer.endArray();
            }
            catch (IOException e) {
                LOG.error("JSON error during response send operation.", (Throwable)e);
            }
        } else {
            validationError = true;
        }
        writer.endObject();
        if (validationError) {
            response.setStatus(400);
        }
    }

    public void onChange(String type, String ... arguments) {
    }
}

