/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.xml;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.sling.xss.impl.xml.AntiSamyRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiSamyXmlParser {
    private static final String DIRECTIVE_EMBED_STYLE_SHEETS = "embedStyleSheets";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AntiSamyRules createRules(InputStream input) throws XMLStreamException, IOException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(input);
        XmlMapper mapper = new XmlMapper(xmlInputFactory, XMLOutputFactory.newInstance());
        AntiSamyRules rules = (AntiSamyRules)mapper.readValue(xmlStreamReader, AntiSamyRules.class);
        if ("true".equals(rules.getDirectivesByName().get(DIRECTIVE_EMBED_STYLE_SHEETS))) {
            this.logger.warn("Unsupported configuration directive {} is set to true and will be ignored", (Object)DIRECTIVE_EMBED_STYLE_SHEETS);
        }
        xmlStreamReader.close();
        return rules;
    }
}

