/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.PomArtifactVersionResolver;
import org.apache.sling.maven.slingstart.PomVariableResolver;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.io.ModelWriter;

@Mojo(name="attach-slingfeature", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AttachSlingStartModel
extends AbstractSlingStartMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model = ProjectHelper.getRawModel(this.project);
        if (this.usePomVariables) {
            model = ModelUtility.applyVariables((Model)model, (ModelUtility.VariableResolver)new PomVariableResolver(this.project));
        }
        if (this.usePomDependencies) {
            model = ModelUtility.applyArtifactVersions((Model)model, (ModelUtility.ArtifactVersionResolver)new PomArtifactVersionResolver(this.project, this.allowUnresolvedPomDependencies));
        }
        File outputFile = new File(this.project.getBuild().getDirectory() + File.separatorChar + "slingstart.txt");
        outputFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(outputFile);){
            ModelWriter.write((Writer)writer, (Model)model);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write model to " + outputFile, (Exception)e);
        }
        if (this.project.getPackaging().equals("slingfeature")) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, "slingfeature", "slingfeature", outputFile);
        }
    }
}

