/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.FilterMultiJoinMergeRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.rules.ProjectJoinTransposeRule;
import org.apache.calcite.rel.rules.ProjectMultiJoinMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class MaterializedViewJoinRule
extends RelOptRule {
    public static final MaterializedViewJoinRule INSTANCE_PROJECT = new MaterializedViewJoinRule(MaterializedViewJoinRule.operand(LogicalProject.class, MaterializedViewJoinRule.operand(Join.class, MaterializedViewJoinRule.operand(Project.class, MaterializedViewJoinRule.operand(TableScan.class, MaterializedViewJoinRule.none()), new RelOptRuleOperand[0]), MaterializedViewJoinRule.operand(Project.class, MaterializedViewJoinRule.operand(TableScan.class, MaterializedViewJoinRule.none()), new RelOptRuleOperand[0])), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "MaterializedViewJoinRule(Project-Project)");
    public static final MaterializedViewJoinRule INSTANCE_TABLE_SCAN = new MaterializedViewJoinRule(MaterializedViewJoinRule.operand(LogicalProject.class, MaterializedViewJoinRule.operand(Join.class, MaterializedViewJoinRule.operand(TableScan.class, MaterializedViewJoinRule.none()), MaterializedViewJoinRule.operand(TableScan.class, MaterializedViewJoinRule.none())), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "MaterializedViewJoinRule(TableScan-TableScan)");
    private final HepProgram multiJoinProgram = new HepProgramBuilder().addRuleInstance(ProjectRemoveRule.INSTANCE).addRuleInstance(ProjectJoinTransposeRule.INSTANCE).addRuleInstance(JoinToMultiJoinRule.INSTANCE).addRuleInstance(ProjectMultiJoinMergeRule.INSTANCE).addRuleInstance(FilterMultiJoinMergeRule.INSTANCE).build();

    protected MaterializedViewJoinRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object rightInput;
        Object leftInput;
        Project originalProject = (Project)call.rel(0);
        if (call.getRelList().size() == 6) {
            leftInput = call.rel(2).copy(call.rel(2).getTraitSet(), (List<RelNode>)ImmutableList.of(call.rel(3)));
            rightInput = call.rel(4).copy(call.rel(4).getTraitSet(), (List<RelNode>)ImmutableList.of(call.rel(5)));
        } else {
            leftInput = call.rel(2);
            rightInput = call.rel(3);
        }
        RelNode join = call.rel(1).copy(call.rel(1).getTraitSet(), (List<RelNode>)ImmutableList.of(leftInput, rightInput));
        RelNode project = call.rel(0).copy(call.rel(0).getTraitSet(), (List<RelNode>)ImmutableList.of((Object)join));
        RelOptPlanner planner = call.getPlanner();
        HepPlanner hepPlanner = new HepPlanner(this.multiJoinProgram, planner.getContext());
        hepPlanner.setRoot(project);
        RelNode best = hepPlanner.findBestExp();
        if (best instanceof Project) {
            best = ((Project)best).getInput();
        }
        if (!(best instanceof MultiJoin)) {
            return;
        }
        this.apply(call, (MultiJoin)best, originalProject);
    }

    protected void apply(RelOptRuleCall call, MultiJoin join, Project originalProject) {
        ImmutableList<RelOptMaterialization> materializations;
        if (!this.isSupportedJoin(join)) {
            return;
        }
        SortedMap<Integer, ImmutableBitSet> queryFilter = this.filterConditions(join);
        if (queryFilter == null) {
            return;
        }
        List<RelOptTable> queryTables = RelOptUtil.findAllTables(join);
        Map<Integer, Pair<RelOptTable, RexInputRef>> queryFields = this.originalFields(join, queryTables);
        if (queryFields == null) {
            return;
        }
        RelOptPlanner planner = call.getPlanner();
        ImmutableList<RelOptMaterialization> immutableList = materializations = planner instanceof VolcanoPlanner ? ((VolcanoPlanner)planner).getMaterializations() : ImmutableList.of();
        if (!materializations.isEmpty()) {
            List<RelOptMaterialization> applicableMaterializations = VolcanoPlanner.getApplicableMaterializations(join, materializations);
            HepPlanner hepPlanner = new HepPlanner(this.multiJoinProgram, planner.getContext());
            for (RelOptMaterialization materialization : applicableMaterializations) {
                List<RexNode> projects;
                Map<Integer, Pair<RelOptTable, RexInputRef>> viewFields;
                SortedMap<Integer, ImmutableBitSet> viewFilter;
                MultiJoin viewJoin;
                Project viewProject;
                RelNode target = materialization.queryRel;
                if (target instanceof TableScan || target instanceof Project && ((Project)target).getInput() instanceof TableScan) continue;
                hepPlanner.setRoot(target);
                target = hepPlanner.findBestExp();
                if (!(target instanceof Project) || !((viewProject = (Project)target).getInput() instanceof MultiJoin) || !this.isSupportedJoin(viewJoin = (MultiJoin)viewProject.getInput())) continue;
                List<RelOptTable> viewTables = RelOptUtil.findAllTables(viewJoin);
                if (queryTables.size() != viewTables.size() || !ImmutableSet.copyOf(queryTables).containsAll(viewTables) || (viewFilter = this.filterConditions(viewJoin)) == null || (viewFields = this.originalFields(viewJoin, viewTables)) == null || (projects = this.materializedViewProjects(queryFields, queryFilter, viewFields, originalProject)).size() != originalProject.getNamedProjects().size()) continue;
                Project newNode = originalProject.copy(originalProject.getTraitSet(), materialization.tableRel, projects, originalProject.getRowType());
                call.transformTo(newNode);
            }
        }
    }

    private boolean isSimpleProjects(MultiJoin join) {
        for (RelNode input : join.getInputs()) {
            if (input instanceof TableScan || input instanceof Project && ((Project)input).getInput() instanceof TableScan) continue;
            return false;
        }
        return true;
    }

    private boolean isSupportedJoin(MultiJoin join) {
        return !join.containsOuter() && join.getPostJoinFilter() == null && this.isSimpleProjects(join);
    }

    private Map<Integer, Pair<RelOptTable, RexInputRef>> originalFields(MultiJoin join, List<RelOptTable> tables) {
        List<ImmutableBitSet> projFields = join.getProjFields();
        LinkedHashMap<Integer, Pair<RelOptTable, RexInputRef>> tableFields = new LinkedHashMap<Integer, Pair<RelOptTable, RexInputRef>>();
        List<RelNode> inputs = join.getInputs();
        int fieldNum = 0;
        for (int i = 0; i < projFields.size(); ++i) {
            List<RexNode> projects;
            if (inputs.get(i) instanceof Project) {
                projects = ((Project)inputs.get(i)).getProjects();
            } else {
                assert (inputs.get(i) instanceof TableScan);
                List<RelDataTypeField> fields = inputs.get(i).getRowType().getFieldList();
                projects = new ArrayList<RexNode>();
                for (int j = 0; j < fields.size(); ++j) {
                    projects.add(new RexInputRef(j, fields.get(j).getType()));
                }
            }
            if (projFields.get(i) == null) {
                return null;
            }
            int bit = projFields.get(i).nextSetBit(0);
            while (bit != -1) {
                if (!(projects.get(bit) instanceof RexInputRef)) {
                    return null;
                }
                tableFields.put(fieldNum, Pair.of(tables.get(i), (RexInputRef)projects.get(bit)));
                ++fieldNum;
                bit = projFields.get(i).nextSetBit(bit + 1);
            }
        }
        return tableFields;
    }

    private Integer getFieldIndex(RexNode operand) {
        if (operand.isA(SqlKind.INPUT_REF)) {
            return ((RexInputRef)operand).getIndex();
        }
        if (operand.isA(SqlKind.CAST)) {
            return this.getFieldIndex(((RexCall)operand).getOperands().get(0));
        }
        return null;
    }

    private SortedMap<Integer, ImmutableBitSet> filterConditions(MultiJoin join) {
        SortedMap<Integer, ImmutableBitSet> equiv = new TreeMap<Integer, ImmutableBitSet>();
        RexNode filter = RexUtil.toCnf(join.getCluster().getRexBuilder(), join.getJoinFilter());
        for (RexNode conjunct : RelOptUtil.conjunctions(filter)) {
            List<RexNode> condition = RelOptUtil.disjunctions(conjunct);
            if (condition.size() == 1 && condition.get(0).isA(SqlKind.EQUALS)) {
                List<RexNode> operands = ((RexCall)condition.get(0)).getOperands();
                Integer index1 = this.getFieldIndex(operands.get(0));
                Integer index2 = this.getFieldIndex(operands.get(1));
                if (index1 == null || index2 == null) {
                    return null;
                }
                equiv.put(index1, ImmutableBitSet.of(index1, index2));
                continue;
            }
            return null;
        }
        equiv = ImmutableBitSet.closure(equiv);
        return equiv;
    }

    private List<RexNode> materializedViewProjects(Map<Integer, Pair<RelOptTable, RexInputRef>> queryFields, SortedMap<Integer, ImmutableBitSet> queryFilter, Map<Integer, Pair<RelOptTable, RexInputRef>> viewFields, Project originalProject) {
        ArrayList viewFieldList = Lists.newArrayList(viewFields.values().iterator());
        ArrayList queryFieldList = Lists.newArrayList(queryFields.values().iterator());
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (Map.Entry<Integer, Pair<RelOptTable, RexInputRef>> field : queryFields.entrySet()) {
            ImmutableBitSet queryEquiv;
            int fieldIndex = viewFieldList.indexOf(field.getValue());
            if (fieldIndex == -1 && (queryEquiv = (ImmutableBitSet)queryFilter.get(field.getKey())) != null) {
                Integer index;
                Iterator<Integer> i$ = queryEquiv.iterator();
                while (i$.hasNext() && (fieldIndex = viewFieldList.indexOf(queryFieldList.get(index = i$.next()))) == -1) {
                }
            }
            if (fieldIndex == -1) break;
            RelDataType type = ((RexInputRef)field.getValue().right).getType();
            RelDataType originalType = originalProject.getProjects().get(projects.size()).getType();
            if (!SqlTypeUtil.canCastFrom(originalType, type, false)) continue;
            projects.add(new RexInputRef(fieldIndex, type));
        }
        return projects;
    }
}

