/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.valuegenerator.AbstractRDBMSGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;

public final class DatastoreUUIDHexGenerator
extends AbstractRDBMSGenerator {
    public DatastoreUUIDHexGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 10;
        if (this.properties != null && this.properties.get("key-cache-size") != null) {
            try {
                this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
            }
            catch (Exception e) {
                throw new ValueGenerationException(LOCALISER.msg("040006", this.properties.get("key-cache-size")));
            }
        }
    }

    public static Class getStorageClass() {
        return String.class;
    }

    protected synchronized ValueGenerationBlock reserveBlock(long size) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> oid = new ArrayList<String>();
        RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
        SQLController sqlControl = srm.getSQLController();
        try {
            DatastoreAdapter dba = srm.getDatastoreAdapter();
            String stmt = dba.getSelectNewUUIDStmt();
            ps = sqlControl.getStatementForQuery(this.connection, stmt);
            int i = 1;
            while ((long)i < size) {
                rs = sqlControl.executeStatementQuery(null, this.connection, stmt, ps);
                if (rs.next()) {
                    String nextId = rs.getString(1);
                    oid.add(nextId);
                }
                ++i;
            }
            ValueGenerationBlock valueGenerationBlock = new ValueGenerationBlock(oid);
            return valueGenerationBlock;
        }
        catch (SQLException e) {
            throw new ValueGenerationException(LOCALISER.msg("040008", (Object)e.getMessage()));
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    sqlControl.closeStatement(this.connection, ps);
                }
            }
            catch (SQLException e) {}
        }
    }
}

