/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.codehaus.janino.util.iterator.TransformingIterator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;
import org.codehaus.janino.util.resource.ZipFileResourceFinder;

public class PathResourceFinder
extends LazyMultiResourceFinder {
    public PathResourceFinder(File[] entries) {
        super(PathResourceFinder.createIterator(Arrays.asList(entries).iterator()));
    }

    public PathResourceFinder(Iterator<ResourceFinder> entries) {
        super(entries);
    }

    public PathResourceFinder(String path) {
        this(PathResourceFinder.parsePath(path));
    }

    private static Iterator<ResourceFinder> createIterator(Iterator<File> entries) {
        return new TransformingIterator(entries){

            protected Object transform(Object o) {
                return PathResourceFinder.createResourceFinder((File)o);
            }
        };
    }

    public static File[] parsePath(String s) {
        int from = 0;
        ArrayList<File> l = new ArrayList<File>();
        while (true) {
            int to;
            if ((to = s.indexOf(File.pathSeparatorChar, from)) == -1) {
                if (from == s.length()) break;
                l.add(new File(s.substring(from)));
                break;
            }
            if (to != from) {
                l.add(new File(s.substring(from, to)));
            }
            from = to + 1;
        }
        return l.toArray(new File[l.size()]);
    }

    private static ResourceFinder createResourceFinder(File entry) {
        if ((entry.getName().endsWith(".jar") || entry.getName().endsWith(".zip")) && entry.isFile()) {
            try {
                return new ZipFileResourceFinder(new ZipFile(entry));
            }
            catch (IOException e) {
                return ResourceFinder.EMPTY_RESOURCE_FINDER;
            }
        }
        if (entry.isDirectory()) {
            return new DirectoryResourceFinder(entry);
        }
        return ResourceFinder.EMPTY_RESOURCE_FINDER;
    }
}

