/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export default {
  app: {
    searchNotData: 'No search results yet',
    toSearch: 'to search',
    toNavigate: 'to navigate',
  },
  drawer: {
    loadingText: 'Loading...',
    cancelText: 'Close',
    okText: 'Confirm',
  },
  form: {
    putAway: 'Put away',
    unfold: 'Unfold',
    maxTip: 'The number of characters should be less than {0}',
    apiSelectNotFound: 'Wait for data loading to complete...',
  },
  icon: {
    placeholder: 'Click the select icon',
    search: 'Search icon',
    copy: 'Copy icon successfully!',
  },
  menu: {
    search: 'Menu search',
  },
  modal: {
    cancelText: 'Close',
    okText: 'Confirm',
    close: 'Close',
    maximize: 'Maximize',
    restore: 'Restore',
  },
  table: {
    settingDens: 'Density',
    settingDensDefault: 'Default',
    settingDensMiddle: 'Middle',
    settingDensSmall: 'Compact',
    settingColumn: 'Column settings',
    settingColumnShow: 'Column display',
    settingIndexColumnShow: 'Index Column',
    settingSelectColumnShow: 'Selection Column',
    settingFixedLeft: 'Fixed Left',
    settingFixedRight: 'Fixed Right',
    settingFullScreen: 'Full Screen',
    index: 'Index',
    total: 'show {0} ~ {1} records, total {2}',
    operation: 'Operation',
  },
  time: {
    before: ' ago',
    after: ' after',
    just: 'just now',
    seconds: ' seconds',
    minutes: ' minutes',
    hours: ' hours',
    days: ' days',
  },
  tree: {
    selectAll: 'Select All',
    unSelectAll: 'Cancel Select',
    expandAll: 'Expand All',
    unExpandAll: 'Collapse all',

    checkStrictly: 'Hierarchical association',
    checkUnStrictly: 'Hierarchical independence',
  },
  upload: {
    save: 'Save',
    upload: 'Upload',
    imgUpload: 'ImageUpload',
    uploaded: 'Uploaded',

    operating: 'Operating',
    del: 'Delete',
    download: 'download',
    saveWarn: 'Please wait for the file to upload and save!',
    saveError: 'There is no file successfully uploaded and cannot be saved!',

    preview: 'Preview',
    choose: 'Select the file',

    accept: 'Support {0} format',
    acceptUpload: 'Only upload files in {0} format',
    maxSize: 'A single file does not exceed {0}MB ',
    maxSizeMultiple: 'Only upload files up to {0}MB!',
    maxNumber: 'Only upload up to {0} files',

    legend: 'Legend',
    fileName: 'File name',
    fileSize: 'File size',
    fileStatue: 'File status',

    startUpload: 'Start upload',
    uploadSuccess: 'Upload successfully',
    uploadError: 'Upload failed',
    uploading: 'Uploading',
    uploadWait: 'Please wait for the file upload to finish',
    reUploadFailed: 'Re-upload failed files',
  },
  verify: {
    error: 'verification failed！',
    time: 'The verification is successful and it takes {time} seconds！',
    redoTip: 'Click the picture to refresh',
    dragText: 'Hold down the slider and drag',
    successText: 'Verified',
  },
};
