/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.interceptor;

import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.streampark.common.util.FileUtils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class UploadFileTypeInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map files = multipartRequest.getFileMap();
            for (String file : files.keySet()) {
                MultipartFile multipartFile = multipartRequest.getFile(file);
                ApiAlertException.throwIfNull(multipartFile, "File to upload can't be null. Upload file failed.");
                boolean fileType = FileUtils.isJarFileType((InputStream)multipartFile.getInputStream());
                ApiAlertException.throwIfFalse(fileType, "Illegal file type, Only support standard jar files. Upload file failed.");
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
    }
}

