/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.enums.OptionState;
import org.apache.streampark.console.core.metrics.flink.CheckPoints;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.alert.AlertService;
import org.apache.streampark.console.core.task.CheckpointProcessor;
import org.apache.streampark.flink.kubernetes.enums.FlinkJobState;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode;
import org.apache.streampark.flink.kubernetes.event.FlinkClusterMetricChangeEvent;
import org.apache.streampark.flink.kubernetes.event.FlinkJobCheckpointChangeEvent;
import org.apache.streampark.flink.kubernetes.event.FlinkJobStatusChangeEvent;
import org.apache.streampark.flink.kubernetes.model.FlinkMetricCV;
import org.apache.streampark.flink.kubernetes.model.JobStatusCV;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.watcher.FlinkJobStatusWatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import scala.Enumeration;

@Component
public class FlinkK8sChangeEventListener {
    @Lazy
    @Autowired
    private ApplicationService applicationService;
    @Lazy
    @Autowired
    private AlertService alertService;
    @Lazy
    @Autowired
    private CheckpointProcessor checkpointProcessor;
    private final ExecutorService executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 5, Runtime.getRuntime().availableProcessors() * 10, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), ThreadUtils.threadFactory((String)"streampark-notify-executor"), new ThreadPoolExecutor.AbortPolicy());

    @AllowConcurrentEvents
    @Subscribe
    public void subscribeJobStatusChange(FlinkJobStatusChangeEvent event) {
        JobStatusCV jobStatus = event.jobStatus();
        TrackId trackId = event.trackId();
        Application app = (Application)this.applicationService.getById(Long.valueOf(trackId.appId()));
        if (app == null) {
            return;
        }
        this.setByJobStatusCV(app, jobStatus);
        this.applicationService.persistMetrics(app);
        FlinkAppState state = FlinkAppState.of(app.getState());
        if (FlinkAppState.FAILED.equals(state) || FlinkAppState.LOST.equals(state) || FlinkAppState.RESTARTING.equals(state) || FlinkAppState.FINISHED.equals(state)) {
            this.executor.execute(() -> this.alertService.alert(app, state));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void subscribeMetricsChange(FlinkClusterMetricChangeEvent event) {
        TrackId trackId = event.trackId();
        ExecutionMode mode = FlinkK8sExecuteMode.toExecutionMode((Enumeration.Value)trackId.executeMode());
        if (ExecutionMode.KUBERNETES_NATIVE_SESSION.equals((Object)mode)) {
            return;
        }
        Application app = (Application)this.applicationService.getById(Long.valueOf(trackId.appId()));
        if (app == null) {
            return;
        }
        FlinkMetricCV metrics = event.metrics();
        app.setJmMemory(metrics.totalJmMemory());
        app.setTmMemory(metrics.totalTmMemory());
        app.setTotalTM(metrics.totalTm());
        app.setTotalSlot(metrics.totalSlot());
        app.setAvailableSlot(metrics.availableSlot());
        this.applicationService.persistMetrics(app);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void subscribeCheckpointChange(FlinkJobCheckpointChangeEvent event) {
        CheckPoints.CheckPoint completed = new CheckPoints.CheckPoint();
        completed.setId(event.checkpoint().id());
        completed.setCheckpointType(event.checkpoint().checkpointType());
        completed.setExternalPath(event.checkpoint().externalPath());
        completed.setIsSavepoint(event.checkpoint().isSavepoint());
        completed.setStatus(event.checkpoint().status());
        completed.setTriggerTimestamp(event.checkpoint().triggerTimestamp());
        CheckPoints.Latest latest = new CheckPoints.Latest();
        latest.setCompleted(completed);
        CheckPoints checkPoint = new CheckPoints();
        checkPoint.setLatest(latest);
        this.checkpointProcessor.process((Application)this.applicationService.getById(Long.valueOf(event.trackId().appId())), checkPoint);
    }

    private void setByJobStatusCV(Application app, JobStatusCV jobStatus) {
        Enumeration.Value state = FlinkJobStatusWatcher.inferFlinkJobStateFromPersist((Enumeration.Value)jobStatus.jobState(), (Enumeration.Value)FlinkAppState.Bridge.toK8sFlinkJobState(FlinkAppState.of(app.getState())));
        long preStartTime = app.getStartTime() != null ? app.getStartTime().getTime() : 0L;
        long startTime = Math.max(jobStatus.jobStartTime(), preStartTime);
        long preEndTime = app.getEndTime() != null ? app.getEndTime().getTime() : 0L;
        long endTime = Math.max(jobStatus.jobEndTime(), preEndTime);
        long duration = jobStatus.duration();
        if (FlinkJobState.isEndState((Enumeration.Value)state)) {
            if (endTime < startTime) {
                endTime = System.currentTimeMillis();
            }
            if (duration <= 0L) {
                duration = endTime - startTime;
            }
        }
        app.setState(FlinkAppState.Bridge.fromK8sFlinkJobState(state).getValue());
        app.setJobId(jobStatus.jobId());
        app.setTotalTask(jobStatus.taskTotal());
        app.setStartTime(new Date(startTime > 0L ? startTime : 0L));
        app.setEndTime(endTime > 0L && endTime >= startTime ? new Date(endTime) : null);
        app.setDuration(duration > 0L ? duration : 0L);
        app.setOptionState(OptionState.NONE.getValue());
    }
}

