/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.command.CreateConfigCmd;
import com.github.dockerjava.api.command.CreateConfigResponse;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import java.util.Base64;
import java.util.Map;

public class CreateConfigCmdImpl
extends AbstrDockerCmd<CreateConfigCmd, CreateConfigResponse>
implements CreateConfigCmd {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Data")
    private String data;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public CreateConfigCmdImpl(CreateConfigCmd.Exec exec) {
        super(exec);
    }

    public CreateConfigCmd withName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name was not specified");
        this.name = name;
        return this;
    }

    public CreateConfigCmd withData(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"data was not specified");
        this.data = Base64.getEncoder().encodeToString(data);
        return this;
    }

    public CreateConfigCmd withLabels(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, (Object)"labels was not specified");
        this.labels = labels;
        return this;
    }
}

