/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.util.Utils;
import org.apache.flink.runtime.operators.DriverStrategy;

public class CoGroupDescriptor
extends OperatorDescriptorDual {
    private final Ordering ordering1;
    private final Ordering ordering2;
    private Partitioner<?> customPartitioner;

    public CoGroupDescriptor(FieldList keys1, FieldList keys2) {
        this(keys1, keys2, null, null);
    }

    public CoGroupDescriptor(FieldList keys1, FieldList keys2, Ordering additionalOrdering1, Ordering additionalOrdering2) {
        super(keys1, keys2);
        Order order;
        Integer field;
        if (additionalOrdering1 != null) {
            this.ordering1 = new Ordering();
            for (Integer key : this.keys1) {
                this.ordering1.appendOrdering(key, null, Order.ANY);
            }
            for (int i = 0; i < additionalOrdering1.getNumberOfFields(); ++i) {
                field = additionalOrdering1.getFieldNumber(i);
                order = additionalOrdering1.getOrder(i);
                this.ordering1.appendOrdering(field, additionalOrdering1.getType(i), order);
            }
        } else {
            this.ordering1 = Utils.createOrdering(this.keys1);
        }
        if (additionalOrdering2 != null) {
            this.ordering2 = new Ordering();
            for (Integer key : this.keys2) {
                this.ordering2.appendOrdering(key, null, Order.ANY);
            }
            for (int i = 0; i < additionalOrdering2.getNumberOfFields(); ++i) {
                field = additionalOrdering2.getFieldNumber(i);
                order = additionalOrdering2.getOrder(i);
                this.ordering2.appendOrdering(field, additionalOrdering2.getType(i), order);
            }
        } else {
            this.ordering2 = Utils.createOrdering(this.keys2);
        }
    }

    public void setCustomPartitioner(Partitioner<?> customPartitioner) {
        this.customPartitioner = customPartitioner;
    }

    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.CO_GROUP;
    }

    @Override
    protected List<OperatorDescriptorDual.GlobalPropertiesPair> createPossibleGlobalProperties() {
        if (this.customPartitioner == null) {
            RequestedGlobalProperties partitioned_left_any = new RequestedGlobalProperties();
            RequestedGlobalProperties partitioned_right_any = new RequestedGlobalProperties();
            partitioned_left_any.setAnyPartitioning((FieldSet)this.keys1);
            partitioned_right_any.setAnyPartitioning((FieldSet)this.keys2);
            RequestedGlobalProperties partitioned_left_hash = new RequestedGlobalProperties();
            RequestedGlobalProperties partitioned_right_hash = new RequestedGlobalProperties();
            partitioned_left_hash.setHashPartitioned((FieldSet)this.keys1);
            partitioned_right_hash.setHashPartitioned((FieldSet)this.keys2);
            return Arrays.asList(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned_left_any, partitioned_right_any), new OperatorDescriptorDual.GlobalPropertiesPair(partitioned_left_hash, partitioned_right_hash));
        }
        RequestedGlobalProperties partitioned_left = new RequestedGlobalProperties();
        partitioned_left.setCustomPartitioned((FieldSet)this.keys1, this.customPartitioner);
        RequestedGlobalProperties partitioned_right = new RequestedGlobalProperties();
        partitioned_right.setCustomPartitioned((FieldSet)this.keys2, this.customPartitioner);
        return Collections.singletonList(new OperatorDescriptorDual.GlobalPropertiesPair(partitioned_left, partitioned_right));
    }

    @Override
    protected List<OperatorDescriptorDual.LocalPropertiesPair> createPossibleLocalProperties() {
        RequestedLocalProperties sort1 = new RequestedLocalProperties(this.ordering1);
        RequestedLocalProperties sort2 = new RequestedLocalProperties(this.ordering2);
        return Collections.singletonList(new OperatorDescriptorDual.LocalPropertiesPair(sort1, sort2));
    }

    @Override
    public boolean areCompatible(RequestedGlobalProperties requested1, RequestedGlobalProperties requested2, GlobalProperties produced1, GlobalProperties produced2) {
        if (produced1.getPartitioning() == PartitioningProperty.HASH_PARTITIONED && produced2.getPartitioning() == PartitioningProperty.HASH_PARTITIONED) {
            return this.checkEquivalentFieldPositionsInKeyFields(produced1.getPartitioningFields(), produced2.getPartitioningFields());
        }
        if (produced1.getPartitioning() == PartitioningProperty.RANGE_PARTITIONED && produced2.getPartitioning() == PartitioningProperty.RANGE_PARTITIONED && produced1.getDataDistribution() != null && produced2.getDataDistribution() != null) {
            return produced1.getPartitioningFields().size() == produced2.getPartitioningFields().size() && this.checkSameOrdering(produced1, produced2, produced1.getPartitioningFields().size()) && produced1.getDataDistribution().equals(produced2.getDataDistribution());
        }
        if (produced1.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING && produced2.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING) {
            return produced1.getPartitioningFields().isExactMatch(this.keys1) && produced2.getPartitioningFields().isExactMatch(this.keys2) && produced1.getCustomPartitioner() != null && produced2.getCustomPartitioner() != null && produced1.getCustomPartitioner().equals(produced2.getCustomPartitioner());
        }
        return false;
    }

    @Override
    public boolean areCoFulfilled(RequestedLocalProperties requested1, RequestedLocalProperties requested2, LocalProperties produced1, LocalProperties produced2) {
        int numRelevantFields = this.keys1.size();
        return this.checkSameOrdering(produced1, produced2, numRelevantFields);
    }

    @Override
    public DualInputPlanNode instantiate(Channel in1, Channel in2, TwoInputNode node) {
        boolean[] inputOrders;
        boolean[] blArray = inputOrders = in1.getLocalProperties().getOrdering() == null ? null : in1.getLocalProperties().getOrdering().getFieldSortDirections();
        if (inputOrders == null || inputOrders.length < this.keys1.size()) {
            throw new CompilerException("BUG: The input strategy does not sufficiently describe the sort orders for a CoGroup operator.");
        }
        if (inputOrders.length > this.keys1.size()) {
            boolean[] tmp = new boolean[this.keys1.size()];
            System.arraycopy(inputOrders, 0, tmp, 0, tmp.length);
            inputOrders = tmp;
        }
        return new DualInputPlanNode(node, "CoGroup (" + node.getOperator().getName() + ")", in1, in2, DriverStrategy.CO_GROUP, this.keys1, this.keys2, inputOrders);
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties in1, GlobalProperties in2) {
        GlobalProperties gp = GlobalProperties.combine(in1, in2);
        if (gp.getUniqueFieldCombination() != null && gp.getUniqueFieldCombination().size() > 0 && gp.getPartitioning() == PartitioningProperty.RANDOM_PARTITIONED) {
            gp.setAnyPartitioning(gp.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gp.clearUniqueFieldCombinations();
        return gp;
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties in1, LocalProperties in2) {
        LocalProperties comb = LocalProperties.combine(in1, in2);
        return comb.clearUniqueFieldSets();
    }
}

